/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.registry.master;

import com.dfsek.terra.addon.AddonClassLoader;
import com.dfsek.terra.addon.AddonPool;
import com.dfsek.terra.addon.PreLoadAddon;
import com.dfsek.terra.addon.exception.AddonLoadException;
import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.addons.TerraAddon;
import com.dfsek.terra.api.injection.Injector;
import com.dfsek.terra.api.injection.exception.InjectionException;
import com.dfsek.terra.registry.OpenRegistry;
import com.dfsek.terra.registry.exception.DuplicateEntryException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class AddonRegistry
extends OpenRegistry<TerraAddon> {
    private final TerraPlugin main;

    public AddonRegistry(TerraPlugin main) {
        this.main = main;
    }

    public AddonRegistry(TerraAddon addon, TerraPlugin main) {
        this.main = main;
        this.add(addon.getName(), addon);
    }

    @Override
    public boolean add(String identifier, TerraAddon addon) {
        if (this.contains(identifier)) {
            throw new IllegalArgumentException("Addon " + identifier + " is already registered.");
        }
        addon.initialize();
        this.main.logger().info("Loaded addon " + addon.getName() + " v" + addon.getVersion() + ", by " + addon.getAuthor());
        return super.add(identifier, addon);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean loadAll() {
        Injector<TerraPlugin> pluginInjector = new Injector<TerraPlugin>(this.main);
        pluginInjector.addExplicitTarget(TerraPlugin.class);
        boolean valid = true;
        File addonsFolder = new File(this.main.getDataFolder(), "addons");
        addonsFolder.mkdirs();
        AddonPool pool = new AddonPool();
        try {
            for (File jar : addonsFolder.listFiles(file -> file.getName().endsWith(".jar"))) {
                this.main.logger().info("Loading Addon(s) from: " + jar.getName());
                for (Class<? extends TerraAddon> addonClass : AddonClassLoader.fetchAddonClasses(jar)) {
                    pool.add(new PreLoadAddon(addonClass, jar));
                }
            }
            pool.buildAll();
            for (PreLoadAddon addon : pool.getAddons()) {
                TerraAddon loadedAddon;
                Constructor<? extends TerraAddon> constructor;
                Class<? extends TerraAddon> addonClass = addon.getAddonClass();
                String logPrefix = "Terra:" + addon.getId();
                Logger addonLogger = Logger.getLogger(logPrefix);
                if (!LogManager.getLogManager().addLogger(addonLogger)) {
                    addonLogger = LogManager.getLogManager().getLogger(logPrefix);
                }
                Injector<Logger> loggerInjector = new Injector<Logger>(addonLogger);
                loggerInjector.addExplicitTarget(Logger.class);
                try {
                    constructor = addonClass.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new AddonLoadException("Addon class has no valid constructor: " + addonClass.getCanonicalName(), e);
                }
                try {
                    loadedAddon = constructor.newInstance(new Object[0]);
                    pluginInjector.inject(loadedAddon);
                    loggerInjector.inject(loadedAddon);
                }
                catch (InjectionException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new AddonLoadException("Failed to load addon \" + " + addon.getId() + "\": ", e);
                }
                try {
                    this.addChecked(loadedAddon.getName(), loadedAddon);
                }
                catch (DuplicateEntryException e) {
                    valid = false;
                    this.main.logger().severe("Duplicate addon ID; addon with ID " + loadedAddon.getName() + " is already loaded.");
                    this.main.logger().severe("Existing addon class: " + ((TerraAddon)this.get(loadedAddon.getName())).getClass().getCanonicalName());
                    this.main.logger().severe("Duplicate addon class: " + addonClass.getCanonicalName());
                }
            }
        }
        catch (AddonLoadException | IOException e) {
            e.printStackTrace();
            valid = false;
        }
        return valid;
    }
}

