/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.world;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.event.events.world.TerraWorldLoadEvent;
import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.api.world.biome.UserDefinedBiome;
import com.dfsek.terra.api.world.biome.provider.BiomeProvider;
import com.dfsek.terra.api.world.palette.Palette;
import com.dfsek.terra.config.pack.ConfigPack;
import com.dfsek.terra.config.pack.WorldConfig;
import com.dfsek.terra.lib.jafama.FastMath;
import com.dfsek.terra.world.generation.math.samplers.Sampler;

public class TerraWorld {
    private final BiomeProvider provider;
    private final WorldConfig config;
    private final boolean safe;
    private final World world;
    private final BlockData air;

    public TerraWorld(World w, ConfigPack c, TerraPlugin main) {
        if (!w.isTerraWorld()) {
            throw new IllegalArgumentException("World " + w + " is not a Terra World!");
        }
        this.world = w;
        this.config = c.toWorldConfig(this);
        this.provider = this.config.getProvider();
        this.air = main.getWorldHandle().createBlockData("minecraft:air");
        main.getEventManager().callEvent(new TerraWorldLoadEvent(this, c));
        this.safe = true;
    }

    public World getWorld() {
        return this.world;
    }

    public BiomeProvider getBiomeProvider() {
        return this.provider;
    }

    public WorldConfig getConfig() {
        return this.config;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public BlockData getUngeneratedBlock(int x, int y, int z) {
        int fdZ;
        int fdX;
        UserDefinedBiome biome = (UserDefinedBiome)this.provider.getBiome(x, z);
        Palette<BlockData> palette = biome.getGenerator(this.world).getPalette(y);
        Sampler sampler = this.config.getSamplerCache().get(x, z);
        double noise = sampler.sample(fdX = FastMath.floorMod(x, 16), y, fdZ = FastMath.floorMod(z, 16));
        if (noise > 0.0) {
            int level = 0;
            for (int yi = this.world.getMaxHeight(); yi > y; --yi) {
                if (sampler.sample(fdX, yi, fdZ) > 0.0) {
                    ++level;
                    continue;
                }
                level = 0;
            }
            return palette.get(level, x, y, z);
        }
        if (y <= biome.getConfig().getSeaLevel()) {
            return biome.getConfig().getOceanPalette().get(biome.getConfig().getSeaLevel() - y, x, y, z);
        }
        return this.air;
    }

    public BlockData getUngeneratedBlock(Location l) {
        return this.getUngeneratedBlock(l.getBlockX(), l.getBlockY(), l.getBlockZ());
    }

    public BlockData getUngeneratedBlock(Vector3 v) {
        return this.getUngeneratedBlock(v.getBlockX(), v.getBlockY(), v.getBlockZ());
    }
}

