/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.world.generation;

import com.dfsek.terra.api.math.noise.NoiseSampler;
import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.world.biome.Generator;
import com.dfsek.terra.api.world.palette.Palette;
import com.dfsek.terra.api.world.palette.holder.PaletteHolder;

public class WorldGenerator
implements Generator {
    private final PaletteHolder palettes;
    private final PaletteHolder slantPalettes;
    private final NoiseSampler noise;
    private final NoiseSampler elevation;
    private final NoiseSampler carving;
    private final NoiseSampler biomeNoise;
    private final double elevationWeight;
    private final int blendDistance;
    private final int blendStep;
    private final double blendWeight;

    public WorldGenerator(PaletteHolder palettes, PaletteHolder slantPalettes, NoiseSampler noise, NoiseSampler elevation, NoiseSampler carving, NoiseSampler biomeNoise, double elevationWeight, int blendDistance, int blendStep, double blendWeight) {
        this.palettes = palettes;
        this.slantPalettes = slantPalettes;
        this.noise = noise;
        this.elevation = elevation;
        this.carving = carving;
        this.biomeNoise = biomeNoise;
        this.elevationWeight = elevationWeight;
        this.blendDistance = blendDistance;
        this.blendStep = blendStep;
        this.blendWeight = blendWeight;
    }

    @Override
    public NoiseSampler getBaseSampler() {
        return this.noise;
    }

    @Override
    public NoiseSampler getElevationSampler() {
        return this.elevation;
    }

    @Override
    public NoiseSampler getCarver() {
        return this.carving;
    }

    @Override
    public int getBlendDistance() {
        return this.blendDistance;
    }

    @Override
    public double getWeight() {
        return this.blendWeight;
    }

    @Override
    public Palette<BlockData> getPalette(int y) {
        return this.palettes.getPalette(y);
    }

    @Override
    public NoiseSampler getBiomeNoise() {
        return this.biomeNoise;
    }

    @Override
    public double getElevationWeight() {
        return this.elevationWeight;
    }

    @Override
    public int getBlendStep() {
        return this.blendStep;
    }

    public Palette<BlockData> getSlantPalette(int y) {
        return this.slantPalettes.getPalette(y);
    }
}

