/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.world.generation.math;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.MathUtil;
import com.dfsek.terra.lib.jafama.FastMath;
import com.dfsek.terra.world.TerraWorld;
import com.dfsek.terra.world.generation.math.samplers.Sampler;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.jetbrains.annotations.NotNull;

public class SamplerCache {
    private final LoadingCache<Long, Sampler> cache;

    public SamplerCache(TerraPlugin main, final TerraWorld world) {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)main.getTerraConfig().getSamplerCache()).build((CacheLoader)new CacheLoader<Long, Sampler>(){

            public Sampler load(@NotNull Long key) {
                int cx = (int)(key >> 32);
                int cz = (int)key.longValue();
                return world.getWorld().getTerraGenerator().createSampler(cx, cz, world.getBiomeProvider(), world.getWorld(), world.getConfig().getTemplate().getElevationBlend());
            }
        });
    }

    public Sampler get(int x, int z) {
        int cx = FastMath.floorDiv(x, 16);
        int cz = FastMath.floorDiv(z, 16);
        return this.getChunk(cx, cz);
    }

    public Sampler getChunk(int cx, int cz) {
        long key = MathUtil.squash(cx, cz);
        return (Sampler)this.cache.getUnchecked((Object)key);
    }

    public void clear() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }
}

