/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.world.generation.math.interpolation;

import com.dfsek.terra.api.util.mutable.MutableInteger;
import com.dfsek.terra.api.world.biome.Generator;
import java.util.Map;

public interface ChunkInterpolator {
    public double getNoise(double var1, double var3, double var5);

    default public double getNoise(int x, int y, int z) {
        return this.getNoise((double)x, (double)y, (double)z);
    }

    default public double computeNoise(Map<Generator, MutableInteger> gens, double x, double y, double z) {
        double n = 0.0;
        double div = 0.0;
        for (Map.Entry<Generator, MutableInteger> entry : gens.entrySet()) {
            Generator gen = entry.getKey();
            int weight = (Integer)entry.getValue().get();
            double noise = this.computeNoise(gen, x, y, z);
            n += noise * (double)weight;
            div += gen.getWeight() * (double)weight;
        }
        return n / div;
    }

    public double computeNoise(Generator var1, double var2, double var4, double var6);
}

