/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.world.generation.math.interpolation;

import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.api.util.mutable.MutableInteger;
import com.dfsek.terra.api.world.biome.Generator;
import com.dfsek.terra.api.world.biome.provider.BiomeProvider;
import com.dfsek.terra.lib.jafama.FastMath;
import com.dfsek.terra.world.generation.math.interpolation.ChunkInterpolator;
import com.dfsek.terra.world.generation.math.interpolation.Interpolator3;
import java.util.HashMap;
import java.util.function.BiFunction;

public class ChunkInterpolator3D
implements ChunkInterpolator {
    private final Interpolator3[][][] interpGrid;
    private final BiFunction<Generator, Vector3, Double> noiseGetter;
    private final int min;
    private final int max;

    public ChunkInterpolator3D(World w, int chunkX, int chunkZ, BiomeProvider provider, BiFunction<Generator, Vector3, Double> noiseGetter) {
        int z;
        int x;
        this.noiseGetter = noiseGetter;
        int xOrigin = chunkX << 4;
        int zOrigin = chunkZ << 4;
        this.max = w.getMaxHeight();
        this.min = w.getMinHeight();
        int range = this.max - this.min + 1;
        int size = range >> 2;
        this.interpGrid = new Interpolator3[4][size][4];
        double[][][] noiseStorage = new double[5][5][size + 1];
        for (x = 0; x < 5; ++x) {
            for (z = 0; z < 5; ++z) {
                Generator generator = provider.getBiome(xOrigin + (x << 2), zOrigin + (z << 2)).getGenerator(w);
                HashMap<Generator, MutableInteger> genMap = new HashMap<Generator, MutableInteger>();
                int step = generator.getBlendStep();
                int blend = generator.getBlendDistance();
                for (int xi = -blend; xi <= blend; ++xi) {
                    for (int zi = -blend; zi <= blend; ++zi) {
                        genMap.computeIfAbsent(provider.getBiome(xOrigin + (x << 2) + xi * step, zOrigin + (z << 2) + zi * step).getGenerator(w), g -> new MutableInteger(0)).increment();
                    }
                }
                for (int y = 0; y < size + 1; ++y) {
                    noiseStorage[x][z][y] = this.computeNoise(genMap, (double)((x << 2) + xOrigin), (double)(y << 2), (double)((z << 2) + zOrigin));
                }
            }
        }
        for (x = 0; x < 4; ++x) {
            for (z = 0; z < 4; ++z) {
                for (int y = 0; y < size; ++y) {
                    this.interpGrid[x][y][z] = new Interpolator3(noiseStorage[x][z][y], noiseStorage[x + 1][z][y], noiseStorage[x][z][y + 1], noiseStorage[x + 1][z][y + 1], noiseStorage[x][z + 1][y], noiseStorage[x + 1][z + 1][y], noiseStorage[x][z + 1][y + 1], noiseStorage[x + 1][z + 1][y + 1]);
                }
            }
        }
    }

    @Override
    public double computeNoise(Generator generator, double x, double y, double z) {
        return this.noiseGetter.apply(generator, new Vector3(x, y, z));
    }

    private static int reRange(int value, int high) {
        return FastMath.max(FastMath.min(value, high), 0);
    }

    @Override
    public double getNoise(double x, double y, double z) {
        return this.interpGrid[ChunkInterpolator3D.reRange((int)x / 4, 3)][FastMath.max(FastMath.min((int)y, this.max), this.min) / 4][ChunkInterpolator3D.reRange((int)z / 4, 3)].trilerp(x % 4.0 / 4.0, y % 4.0 / 4.0, z % 4.0 / 4.0);
    }

    @Override
    public double getNoise(int x, int y, int z) {
        return this.interpGrid[x / 4][y / 4][z / 4].trilerp((double)(x % 4) / 4.0, (double)(y % 4) / 4.0, (double)(z % 4) / 4.0);
    }
}

