/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.world.generation.math.samplers;

import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.api.world.biome.provider.BiomeProvider;
import com.dfsek.terra.lib.jafama.FastMath;
import com.dfsek.terra.world.generation.math.interpolation.ChunkInterpolator3D;
import com.dfsek.terra.world.generation.math.interpolation.ElevationInterpolator;
import com.dfsek.terra.world.generation.math.samplers.Sampler;

public class Sampler3D
implements Sampler {
    private final ChunkInterpolator3D interpolator;
    private final ElevationInterpolator elevationInterpolator;

    public Sampler3D(int x, int z, BiomeProvider provider, World world, int elevationSmooth) {
        this.interpolator = new ChunkInterpolator3D(world, x, z, provider, (generator, coord) -> generator.getBaseSampler().getNoise((Vector3)coord));
        this.elevationInterpolator = new ElevationInterpolator(world, x, z, provider, elevationSmooth);
    }

    @Override
    public double sample(double x, double y, double z) {
        return this.interpolator.getNoise(x, y, z) + this.elevationInterpolator.getElevation(FastMath.roundToInt(x), FastMath.roundToInt(z));
    }

    @Override
    public double sample(int x, int y, int z) {
        return this.interpolator.getNoise(x, y, z) + this.elevationInterpolator.getElevation(FastMath.roundToInt(x), FastMath.roundToInt(z));
    }
}

