/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.world.population;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.platform.block.Block;
import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.platform.block.BlockType;
import com.dfsek.terra.api.platform.handle.WorldHandle;
import com.dfsek.terra.api.platform.world.Chunk;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.api.util.FastRandom;
import com.dfsek.terra.api.util.world.PopulationUtil;
import com.dfsek.terra.api.world.generation.Chunkified;
import com.dfsek.terra.api.world.generation.TerraBlockPopulator;
import com.dfsek.terra.carving.UserDefinedCarver;
import com.dfsek.terra.config.pack.WorldConfig;
import com.dfsek.terra.config.templates.CarverTemplate;
import com.dfsek.terra.profiler.ProfileFrame;
import com.dfsek.terra.world.TerraWorld;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CavePopulator
implements TerraBlockPopulator,
Chunkified {
    private static final Map<BlockType, BlockData> shiftStorage = new HashMap<BlockType, BlockData>();
    private final TerraPlugin main;

    public CavePopulator(TerraPlugin main) {
        this.main = main;
    }

    @Override
    public void populate(@NotNull World world, @NotNull Chunk chunk) {
        TerraWorld tw = this.main.getWorld(world);
        WorldHandle handle = this.main.getWorldHandle();
        BlockData AIR = handle.createBlockData("minecraft:air");
        try (ProfileFrame ignore = this.main.getProfiler().profile("carving");){
            FastRandom random = PopulationUtil.getRandom(chunk);
            if (!tw.isSafe()) {
                return;
            }
            WorldConfig config = tw.getConfig();
            if (config.getTemplate().disableCarvers()) {
                return;
            }
            for (UserDefinedCarver c : config.getCarvers()) {
                CarverTemplate template = c.getConfig();
                HashMap shiftCandidate = new HashMap();
                HashSet updateNeeded = new HashSet();
                c.carve(chunk.getX(), chunk.getZ(), world, (v, type) -> {
                    try (ProfileFrame ignored = this.main.getProfiler().profile("carving:" + c.getConfig().getID());){
                        Block b = chunk.getBlock(v.getBlockX(), v.getBlockY(), v.getBlockZ());
                        BlockData m = b.getBlockData();
                        BlockType re = m.getBlockType();
                        switch (type) {
                            case CENTER: {
                                if (!template.getInner().canReplace(re)) return;
                                b.setBlockData(template.getInner().get(v.getBlockY()).get(random), false);
                                if (template.getUpdate().contains(re)) {
                                    updateNeeded.add(b);
                                }
                                if (!template.getShift().containsKey(re)) return;
                                shiftCandidate.put(b.getLocation(), m);
                                return;
                            }
                            case WALL: {
                                if (!template.getOuter().canReplace(re)) return;
                                b.setBlockData(template.getOuter().get(v.getBlockY()).get(random), false);
                                if (template.getUpdate().contains(re)) {
                                    updateNeeded.add(b);
                                }
                                if (!template.getShift().containsKey(re)) return;
                                shiftCandidate.put(b.getLocation(), m);
                                return;
                            }
                            case TOP: {
                                if (!template.getTop().canReplace(re)) return;
                                b.setBlockData(template.getTop().get(v.getBlockY()).get(random), false);
                                if (template.getUpdate().contains(re)) {
                                    updateNeeded.add(b);
                                }
                                if (!template.getShift().containsKey(re)) return;
                                shiftCandidate.put(b.getLocation(), m);
                                return;
                            }
                            case BOTTOM: {
                                if (!template.getBottom().canReplace(re)) return;
                                b.setBlockData(template.getBottom().get(v.getBlockY()).get(random), false);
                                if (template.getUpdate().contains(re)) {
                                    updateNeeded.add(b);
                                }
                                if (!template.getShift().containsKey(re)) return;
                                shiftCandidate.put(b.getLocation(), m);
                                return;
                            }
                        }
                        return;
                    }
                });
                for (Map.Entry entry : shiftCandidate.entrySet()) {
                    Location l = (Location)entry.getKey();
                    Location mut = l.clone();
                    BlockData orig = l.getBlock().getBlockData();
                    do {
                        mut.subtract(0, 1, 0);
                    } while (mut.getY() > 0.0 && mut.getBlock().getBlockData().matches(orig));
                    try {
                        if (!template.getShift().get(((BlockData)entry.getValue()).getBlockType()).contains(mut.getBlock().getBlockData().getBlockType())) continue;
                        mut.getBlock().setBlockData(shiftStorage.computeIfAbsent(((BlockData)entry.getValue()).getBlockType(), BlockType::getDefaultData), false);
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                for (Block b : updateNeeded) {
                    BlockData orig = b.getBlockData();
                    b.setBlockData(AIR, false);
                    b.setBlockData(orig, true);
                }
            }
        }
    }
}

