/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.world.population;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.vector.Vector2;
import com.dfsek.terra.api.platform.world.Chunk;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.api.util.FastRandom;
import com.dfsek.terra.api.util.world.PopulationUtil;
import com.dfsek.terra.api.world.biome.UserDefinedBiome;
import com.dfsek.terra.api.world.biome.provider.BiomeProvider;
import com.dfsek.terra.api.world.generation.TerraBlockPopulator;
import com.dfsek.terra.profiler.ProfileFrame;
import com.dfsek.terra.world.TerraWorld;
import com.dfsek.terra.world.population.items.flora.FloraLayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public class FloraPopulator
implements TerraBlockPopulator {
    private final TerraPlugin main;

    public FloraPopulator(TerraPlugin main) {
        this.main = main;
    }

    @Override
    public void populate(@NotNull World world, @NotNull Chunk chunk) {
        TerraWorld tw = this.main.getWorld(world);
        try (ProfileFrame ignore = this.main.getProfiler().profile("flora");){
            if (tw.getConfig().getTemplate().disableFlora()) {
                return;
            }
            if (!tw.isSafe()) {
                return;
            }
            BiomeProvider provider = tw.getBiomeProvider();
            HashMap<Vector2, List<FloraLayer>> layers = new HashMap<Vector2, List<FloraLayer>>();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    UserDefinedBiome biome = (UserDefinedBiome)provider.getBiome((chunk.getX() << 4) + x, (chunk.getZ() << 4) + z);
                    Vector2 l = new Vector2(x, z);
                    layers.put(l, biome.getConfig().getFlora());
                }
            }
            FastRandom random = PopulationUtil.getRandom(chunk);
            int iter = 0;
            boolean finished = false;
            while (!finished) {
                finished = true;
                for (Map.Entry entry : layers.entrySet()) {
                    if (((List)entry.getValue()).size() <= iter) continue;
                    finished = false;
                    FloraLayer layer = (FloraLayer)((List)entry.getValue()).get(iter);
                    if (!(layer.getDensity() >= ((Random)random).nextDouble() * 100.0)) continue;
                    layer.place(chunk, (Vector2)entry.getKey());
                }
                ++iter;
            }
        }
    }
}

