/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.world.population;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.vector.Vector2;
import com.dfsek.terra.api.platform.world.Chunk;
import com.dfsek.terra.api.platform.world.World;
import com.dfsek.terra.api.util.FastRandom;
import com.dfsek.terra.api.util.world.PopulationUtil;
import com.dfsek.terra.api.world.biome.UserDefinedBiome;
import com.dfsek.terra.api.world.biome.provider.BiomeProvider;
import com.dfsek.terra.api.world.generation.TerraBlockPopulator;
import com.dfsek.terra.lib.jafama.FastMath;
import com.dfsek.terra.profiler.ProfileFrame;
import com.dfsek.terra.world.TerraWorld;
import com.dfsek.terra.world.population.items.tree.TreeLayer;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public class TreePopulator
implements TerraBlockPopulator {
    private final TerraPlugin main;

    public TreePopulator(TerraPlugin main) {
        this.main = main;
    }

    private static int offset(Random r, int i) {
        return FastMath.min(FastMath.max(i + r.nextInt(3) - 1, 0), 15);
    }

    @Override
    public void populate(@NotNull World world, @NotNull Chunk chunk) {
        TerraWorld tw = this.main.getWorld(world);
        try (ProfileFrame ignore = this.main.getProfiler().profile("tree");){
            if (tw.getConfig().getTemplate().disableTrees()) {
                return;
            }
            if (!tw.isSafe()) {
                return;
            }
            BiomeProvider provider = tw.getBiomeProvider();
            FastRandom random = PopulationUtil.getRandom(chunk);
            for (int x = 0; x < 16; x += 2) {
                for (int z = 0; z < 16; z += 2) {
                    UserDefinedBiome biome = (UserDefinedBiome)provider.getBiome((chunk.getX() << 4) + x, (chunk.getZ() << 4) + z);
                    for (TreeLayer layer : biome.getConfig().getTrees()) {
                        if (!(layer.getDensity() >= ((Random)random).nextDouble() * 100.0)) continue;
                        layer.place(chunk, new Vector2(TreePopulator.offset(random, x), TreePopulator.offset(random, z)));
                    }
                }
            }
        }
    }
}

