/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.world.population.items.flora;

import com.dfsek.terra.api.math.Range;
import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.platform.block.Block;
import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.platform.block.BlockFace;
import com.dfsek.terra.api.platform.world.Chunk;
import com.dfsek.terra.api.util.GlueList;
import com.dfsek.terra.api.util.collections.MaterialSet;
import com.dfsek.terra.api.world.flora.Flora;
import java.util.List;

public class ConstantFlora
implements Flora {
    private final List<BlockData> data;
    private final MaterialSet spawns;

    public ConstantFlora(MaterialSet spawns, List<BlockData> data) {
        this.data = data;
        this.spawns = spawns;
    }

    @Override
    public List<Block> getValidSpawnsAt(Chunk chunk, int x, int z, Range check) {
        GlueList<Block> blocks = new GlueList<Block>();
        for (int y : check) {
            Block block = chunk.getBlock(x, y, z);
            if (!this.spawns.contains(block.getType()) || !this.valid(block)) continue;
            blocks.add(chunk.getBlock(x, y, z));
        }
        return blocks;
    }

    private boolean valid(Block block) {
        for (int i = 1; i < this.data.size() + 1; ++i) {
            if ((block = block.getRelative(BlockFace.UP)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean plant(Location l) {
        for (int i = 1; i < this.data.size() + 1; ++i) {
            l.clone().add(0.0, i, 0.0).getBlock().setBlockData(this.data.get(i - 1), false);
        }
        return true;
    }
}

