/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.world.population.items.flora;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.Range;
import com.dfsek.terra.api.math.vector.Location;
import com.dfsek.terra.api.platform.block.Block;
import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.platform.block.BlockFace;
import com.dfsek.terra.api.platform.block.data.Directional;
import com.dfsek.terra.api.platform.block.data.MultipleFacing;
import com.dfsek.terra.api.platform.block.data.Rotatable;
import com.dfsek.terra.api.platform.handle.WorldHandle;
import com.dfsek.terra.api.platform.world.Chunk;
import com.dfsek.terra.api.util.FastRandom;
import com.dfsek.terra.api.util.GlueList;
import com.dfsek.terra.api.util.collections.MaterialSet;
import com.dfsek.terra.api.world.flora.Flora;
import com.dfsek.terra.api.world.palette.Palette;
import com.dfsek.terra.lib.jafama.FastMath;
import java.util.ArrayList;
import java.util.List;

public class TerraFlora
implements Flora {
    private final Palette<BlockData> floraPalette;
    private final boolean physics;
    private final boolean ceiling;
    private final MaterialSet irrigable;
    private final MaterialSet spawnable;
    private final MaterialSet replaceable;
    private final MaterialSet testRotation;
    private final int maxPlacements;
    private final Search search;
    private final boolean spawnBlacklist;
    private final int irrigableOffset;
    private final TerraPlugin main;

    public TerraFlora(Palette<BlockData> floraPalette, boolean physics, boolean ceiling, MaterialSet irrigable, MaterialSet spawnable, MaterialSet replaceable, MaterialSet testRotation, int maxPlacements, Search search, boolean spawnBlacklist, int irrigableOffset, TerraPlugin main) {
        this.floraPalette = floraPalette;
        this.physics = physics;
        this.testRotation = testRotation;
        this.spawnBlacklist = spawnBlacklist;
        this.ceiling = ceiling;
        this.irrigable = irrigable;
        this.spawnable = spawnable;
        this.replaceable = replaceable;
        this.maxPlacements = maxPlacements;
        this.search = search;
        this.irrigableOffset = irrigableOffset;
        this.main = main;
    }

    @Override
    public List<Block> getValidSpawnsAt(Chunk chunk, int x, int z, Range range) {
        int size = this.floraPalette.getSize();
        Block current = chunk.getBlock(x, this.search.equals((Object)Search.UP) ? range.getMin() : range.getMax(), z);
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int y : range) {
            if (y > 255 || y < 0 || this.spawnBlacklist == this.spawnable.contains((current = current.getRelative(this.search.equals((Object)Search.UP) ? BlockFace.UP : BlockFace.DOWN)).getType()) || !this.isIrrigated(current.getRelative(BlockFace.UP, this.irrigableOffset)) || !this.valid(size, current)) continue;
            blocks.add(current);
            if (this.maxPlacements <= 0 || blocks.size() < this.maxPlacements) continue;
            break;
        }
        return blocks;
    }

    private boolean valid(int size, Block block) {
        for (int i = 0; i < size; ++i) {
            if (block.getY() + 1 > 255 || block.getY() < 0) {
                return false;
            }
            if (this.replaceable.contains((block = block.getRelative(this.ceiling ? BlockFace.DOWN : BlockFace.UP)).getType())) continue;
            return false;
        }
        return true;
    }

    private boolean isIrrigated(Block b) {
        if (this.irrigable == null) {
            return true;
        }
        return this.irrigable.contains(b.getRelative(BlockFace.NORTH).getType()) || this.irrigable.contains(b.getRelative(BlockFace.SOUTH).getType()) || this.irrigable.contains(b.getRelative(BlockFace.EAST).getType()) || this.irrigable.contains(b.getRelative(BlockFace.WEST).getType());
    }

    @Override
    public boolean plant(Location location) {
        GlueList faces;
        WorldHandle handle = this.main.getWorldHandle();
        boolean doRotation = this.testRotation.size() > 0;
        int size = this.floraPalette.getSize();
        int c = this.ceiling ? -1 : 1;
        List<Object> list = faces = doRotation ? this.getFaces(location.clone().add(0.0, c, 0.0).getBlock()) : new GlueList();
        if (doRotation && faces.size() == 0) {
            return false;
        }
        int i = 0;
        while (FastMath.abs(i) < size) {
            int lvl = FastMath.abs(i);
            BlockData data = this.floraPalette.get(this.ceiling ? lvl : size - lvl - 1, location.getX(), location.getY(), location.getZ()).clone();
            if (doRotation) {
                BlockFace oneFace = (BlockFace)((Object)faces.get(new FastRandom(location.getBlockX() ^ location.getBlockZ()).nextInt(faces.size())));
                if (data instanceof Directional) {
                    ((Directional)data).setFacing(oneFace.getOppositeFace());
                } else if (data instanceof MultipleFacing) {
                    MultipleFacing o = (MultipleFacing)data;
                    for (BlockFace face : o.getFaces()) {
                        o.setFace(face, false);
                    }
                    for (BlockFace face : faces) {
                        o.setFace(face, true);
                    }
                } else if (data instanceof Rotatable) {
                    ((Rotatable)data).setRotation(oneFace);
                }
            }
            location.clone().add(0.0, i + c, 0.0).getBlock().setBlockData(data, this.physics);
            i += c;
        }
        return true;
    }

    private List<BlockFace> getFaces(Block b) {
        GlueList<BlockFace> faces = new GlueList<BlockFace>();
        this.test(faces, BlockFace.NORTH, b);
        this.test(faces, BlockFace.SOUTH, b);
        this.test(faces, BlockFace.EAST, b);
        this.test(faces, BlockFace.WEST, b);
        return faces;
    }

    private void test(List<BlockFace> faces, BlockFace f, Block b) {
        if (this.testRotation.contains(b.getRelative(f).getType())) {
            faces.add(f);
        }
    }

    public static enum Search {
        UP,
        DOWN;

    }
}

