/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.world.population.items.ores;

import com.dfsek.terra.api.util.GlueList;
import com.dfsek.terra.api.util.generic.pair.ImmutablePair;
import com.dfsek.terra.world.population.items.ores.Ore;
import com.dfsek.terra.world.population.items.ores.OreConfig;
import java.util.List;
import java.util.function.BiConsumer;

public class OreHolder {
    private final List<Entry> entries = new GlueList<Entry>();

    public void forEach(BiConsumer<String, ImmutablePair<Ore, OreConfig>> consumer) {
        this.entries.forEach((? super T entry) -> consumer.accept(entry.getId(), ImmutablePair.of(entry.getOre(), entry.getConfig())));
    }

    public OreHolder add(Ore ore, OreConfig config, String id) {
        this.entries.add(new Entry(ore, config, id));
        return this;
    }

    private static final class Entry {
        private final Ore ore;
        private final OreConfig config;
        private final String id;

        private Entry(Ore ore, OreConfig config, String id) {
            this.ore = ore;
            this.config = config;
            this.id = id;
        }

        public OreConfig getConfig() {
            return this.config;
        }

        public Ore getOre() {
            return this.ore;
        }

        public String getId() {
            return this.id;
        }
    }
}

