/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.world.population.items.ores;

import com.dfsek.terra.api.TerraPlugin;
import com.dfsek.terra.api.math.Range;
import com.dfsek.terra.api.math.vector.Vector3;
import com.dfsek.terra.api.platform.block.Block;
import com.dfsek.terra.api.platform.block.BlockData;
import com.dfsek.terra.api.platform.world.Chunk;
import com.dfsek.terra.api.util.collections.MaterialSet;
import com.dfsek.terra.lib.jafama.FastMath;
import com.dfsek.terra.world.population.items.ores.Ore;
import java.util.Random;

public class VanillaOre
extends Ore {
    private final Range sizeRange;

    public VanillaOre(BlockData material, MaterialSet replaceable, boolean applyGravity, Range size, TerraPlugin main) {
        super(material, replaceable, applyGravity, main);
        this.sizeRange = size;
    }

    @Override
    public void generate(Vector3 location, Chunk chunk, Random random) {
        double size = this.sizeRange.get(random);
        int centerX = location.getBlockX();
        int centerZ = location.getBlockZ();
        int centerY = location.getBlockY();
        double f = (double)random.nextFloat() * Math.PI;
        double fS = FastMath.sin(f) * size / 8.0;
        double fC = FastMath.cos(f) * size / 8.0;
        double d1 = (double)(centerX + 8) + fS;
        double d2 = (double)(centerX + 8) - fS;
        double d3 = (double)(centerZ + 8) + fC;
        double d4 = (double)(centerZ + 8) - fC;
        double d5 = (double)(centerY + random.nextInt(3)) - 2.0;
        double d6 = (double)(centerY + random.nextInt(3)) - 2.0;
        int i = 0;
        while ((double)i < size) {
            double iFactor = (double)i / size;
            double d10 = random.nextDouble() * size / 16.0;
            double d11 = (FastMath.sin(Math.PI * iFactor) + 1.0) * d10 + 1.0;
            int xStart = FastMath.roundToInt(FastMath.floor(d1 + (d2 - d1) * iFactor - d11 / 2.0));
            int yStart = FastMath.roundToInt(FastMath.floor(d5 + (d6 - d5) * iFactor - d11 / 2.0));
            int zStart = FastMath.roundToInt(FastMath.floor(d3 + (d4 - d3) * iFactor - d11 / 2.0));
            int xEnd = FastMath.roundToInt(FastMath.floor(d1 + (d2 - d1) * iFactor + d11 / 2.0));
            int yEnd = FastMath.roundToInt(FastMath.floor(d5 + (d6 - d5) * iFactor + d11 / 2.0));
            int zEnd = FastMath.roundToInt(FastMath.floor(d3 + (d4 - d3) * iFactor + d11 / 2.0));
            for (int x = xStart; x <= xEnd; ++x) {
                double d13 = ((double)x + 0.5 - (d1 + (d2 - d1) * iFactor)) / (d11 / 2.0);
                if (!(d13 * d13 < 1.0)) continue;
                for (int y = yStart; y <= yEnd; ++y) {
                    double d14 = ((double)y + 0.5 - (d5 + (d6 - d5) * iFactor)) / (d11 / 2.0);
                    if (!(d13 * d13 + d14 * d14 < 1.0)) continue;
                    for (int z = zStart; z <= zEnd; ++z) {
                        double d15 = ((double)z + 0.5 - (d3 + (d4 - d3) * iFactor)) / (d11 / 2.0);
                        if (x > 15 || z > 15 || y > 255 || x < 0 || z < 0 || y < 0) continue;
                        Block block = chunk.getBlock(x, y, z);
                        if (!(d13 * d13 + d14 * d14 + d15 * d15 < 1.0) || !this.getReplaceable().contains(block.getType())) continue;
                        block.setBlockData(this.getMaterial(), this.isApplyGravity());
                    }
                }
            }
            ++i;
        }
    }
}

