/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot;

import java.util.Optional;
import net.blay09.mods.trashslot.InternalMethodsImpl;
import net.blay09.mods.trashslot.TrashHelper;
import net.blay09.mods.trashslot.TrashSlotConfig;
import net.blay09.mods.trashslot.api.TrashSlotAPI;
import net.blay09.mods.trashslot.client.ModKeyBindings;
import net.blay09.mods.trashslot.client.TrashSlotGuiHandler;
import net.blay09.mods.trashslot.client.gui.layout.ChestContainerLayout;
import net.blay09.mods.trashslot.client.gui.layout.SimpleGuiContainerLayout;
import net.blay09.mods.trashslot.network.MessageTrashSlotContent;
import net.blay09.mods.trashslot.network.NetworkHandler;
import net.minecraft.client.gui.screen.inventory.ChestScreen;
import net.minecraft.client.gui.screen.inventory.CraftingScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod(value="trashslot")
public class TrashSlot {
    public static final String MOD_ID = "trashslot";
    public static boolean isServerSideInstalled;
    public static Optional<TrashSlotGuiHandler> trashSlotGui;

    public TrashSlot() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupCommon);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, TrashSlotConfig.clientSpec);
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        TrashSlotAPI.__setupAPI(new InternalMethodsImpl());
        DeferredWorkQueue.runLater(NetworkHandler::init);
    }

    private void setupClient(FMLClientSetupEvent event) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            TrashSlotAPI.registerLayout(InventoryScreen.class, SimpleGuiContainerLayout.DEFAULT_ENABLED);
            TrashSlotAPI.registerLayout(CraftingScreen.class, SimpleGuiContainerLayout.DEFAULT_ENABLED);
            TrashSlotAPI.registerLayout(ChestScreen.class, new ChestContainerLayout());
            trashSlotGui = Optional.of(new TrashSlotGuiHandler());
            DeferredWorkQueue.runLater(() -> {
                trashSlotGui.ifPresent(arg_0 -> ((IEventBus)MinecraftForge.EVENT_BUS).register(arg_0));
                ModKeyBindings.init();
            });
        });
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        MessageTrashSlotContent message = new MessageTrashSlotContent(ItemStack.field_190927_a);
        NetworkHandler.instance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)message);
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            NetworkHandler.instance.sendTo((Object)new MessageTrashSlotContent(ItemStack.field_190927_a), ((ServerPlayerEntity)event.getEntity()).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public void onPlayerOpenContainer(PlayerContainerEvent.Open event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            ItemStack trashItem = TrashHelper.getTrashItem(player);
            NetworkHandler.instance.sendTo((Object)new MessageTrashSlotContent(trashItem), ((ServerPlayerEntity)player).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    static {
        trashSlotGui = Optional.empty();
    }
}

