/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.network;

import java.util.function.Supplier;
import net.blay09.mods.trashslot.TrashHelper;
import net.blay09.mods.trashslot.network.MessageTrashSlotContent;
import net.blay09.mods.trashslot.network.NetworkHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageDeleteFromSlot {
    private final int slotNumber;
    private final boolean isShiftDown;

    public MessageDeleteFromSlot(int slotNumber, boolean isShiftDown) {
        this.slotNumber = slotNumber;
        this.isShiftDown = isShiftDown;
    }

    public static void encode(MessageDeleteFromSlot message, PacketBuffer buf) {
        buf.writeByte(message.slotNumber);
        buf.writeBoolean(message.isShiftDown);
    }

    public static MessageDeleteFromSlot decode(PacketBuffer buf) {
        byte slotNumber = buf.readByte();
        boolean isShiftDown = buf.readBoolean();
        return new MessageDeleteFromSlot(slotNumber, isShiftDown);
    }

    public static void handle(MessageDeleteFromSlot message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            if (message.slotNumber == -1) {
                TrashHelper.setTrashItem((PlayerEntity)player, ItemStack.field_190927_a);
                NetworkHandler.instance.reply((Object)new MessageTrashSlotContent(ItemStack.field_190927_a), context);
                return;
            }
            if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                return;
            }
            Container container = player.field_71070_bA;
            Slot deleteSlot = (Slot)container.field_75151_b.get(message.slotNumber);
            if (deleteSlot instanceof CraftingResultSlot) {
                return;
            }
            if (message.isShiftDown) {
                ItemStack deleteStack = deleteSlot.func_75211_c().func_77946_l();
                if (!deleteStack.func_190926_b() && MessageDeleteFromSlot.attemptDeleteFromSlot((PlayerEntity)player, container, message.slotNumber)) {
                    ItemStack slotStack;
                    for (int i = 0; i < container.field_75151_b.size() && ((slotStack = ((Slot)container.field_75151_b.get(i)).func_75211_c()).func_190926_b() || !ItemStack.func_185132_d((ItemStack)slotStack, (ItemStack)deleteStack) || !ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)deleteStack) || MessageDeleteFromSlot.attemptDeleteFromSlot((PlayerEntity)player, container, i)); ++i) {
                    }
                }
            } else {
                MessageDeleteFromSlot.attemptDeleteFromSlot((PlayerEntity)player, container, message.slotNumber);
            }
            NetworkHandler.instance.reply((Object)new MessageTrashSlotContent(TrashHelper.getTrashItem((PlayerEntity)player)), context);
        });
        context.setPacketHandled(true);
    }

    private static boolean attemptDeleteFromSlot(PlayerEntity player, Container container, int slotNumber) {
        ItemStack mouseStack;
        ItemStack itemStack = container.func_184996_a(slotNumber, 0, ClickType.PICKUP, player);
        if (ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)(mouseStack = player.field_71071_by.func_70445_o()))) {
            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
            TrashHelper.setTrashItem(player, mouseStack);
            return !itemStack.func_190926_b();
        }
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, 0, mouseStack));
        return false;
    }
}

