/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.villagersrespawn.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="villagersrespawn", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static int debugLevel;
    public static int respawnHealth;
    public static boolean respawnXpLoss;
    public static int respawnPercentage;
    public static boolean hardModeZombieDeaths;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MyConfig.bakeConfig();
        }
    }

    public static void bakeConfig() {
        debugLevel = (Integer)MyConfig.COMMON.debugLevel.get();
        respawnHealth = (Integer)MyConfig.COMMON.respawnHealth.get();
        respawnXpLoss = (Boolean)MyConfig.COMMON.respawnXpLoss.get();
        respawnPercentage = (Integer)MyConfig.COMMON.respawnPercentage.get();
        hardModeZombieDeaths = (Boolean)MyConfig.COMMON.hardModeZombieDeaths.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.IntValue respawnHealth;
        public final ForgeConfigSpec.BooleanValue respawnXpLoss;
        public final ForgeConfigSpec.IntValue respawnPercentage;
        public final ForgeConfigSpec.BooleanValue hardModeZombieDeaths;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Villager Respawn Control Values");
            this.debugLevel = builder.comment("Debug Level: 0 = Off, 1 = Log, 2 = Chat+Log").translation("villagersrespawn.config.debugLevel").defineInRange("debugLevel", () -> 0, 0, 2);
            this.respawnHealth = builder.comment("Respawn Health").translation("villagersrespawn.config.respawnHealth").defineInRange("respawnHealth", () -> 20, 1, 25);
            this.respawnXpLoss = builder.comment("Respawn XpLoss").translation("villagersrespawn.config.respawnXpLoss").define("respawnXpLoss", () -> true);
            this.respawnPercentage = builder.comment("Respawn Percentage").translation("villagersrespawn.config.respawnPercentage").defineInRange("respawnPercentage", () -> 104, 1, 110);
            this.hardModeZombieDeaths = builder.comment("Zombie Deaths In Hard Mode").translation("villagersrespawn.config.hardModeZombieDeaths").define("hardModeZombieDeaths", () -> true);
            builder.pop();
        }
    }
}

