/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.villagersrespawn.events;

import com.mactso.villagersrespawn.config.MyConfig;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VillagerDeathEvent {
    private static final int[] xpLevels = new int[]{0, 10, 70, 150, 250};

    @SubscribeEvent
    public void doVillagerRespawn(LivingDeathEvent event) {
        LivingEntity eventEntity = event.getEntityLiving();
        if (event.getEntity() == null) {
            return;
        }
        if (!(eventEntity.field_70170_p instanceof ServerWorld)) {
            return;
        }
        if (eventEntity instanceof VillagerEntity) {
            Brain vb;
            Optional villagerHome;
            double randomD100Roll = eventEntity.field_70170_p.field_73012_v.nextDouble() * 100.0;
            randomD100Roll = Math.ceil(randomD100Roll);
            Difficulty difficulty = eventEntity.field_70170_p.func_175659_aa();
            if (difficulty == Difficulty.NORMAL) {
                randomD100Roll += 5.0;
            }
            if (difficulty == Difficulty.HARD) {
                randomD100Roll += 10.0;
            }
            if (randomD100Roll > (double)MyConfig.respawnPercentage) {
                return;
            }
            VillagerEntity ve = (VillagerEntity)eventEntity;
            String deathMessage = "Died for unknown reasons.";
            if (ve.func_189748_bU() != null) {
                deathMessage = ve.func_189748_bU().func_151519_b((LivingEntity)ve).toString();
                if (ve.func_189748_bU().func_76346_g() instanceof ZombieEntity && ve.field_70170_p.func_175659_aa() == Difficulty.HARD && MyConfig.hardModeZombieDeaths) {
                    return;
                }
            }
            if ((villagerHome = (vb = ve.func_213375_cj()).func_218207_c(MemoryModuleType.field_220941_b)).isPresent()) {
                GlobalPos gVHP = (GlobalPos)villagerHome.get();
                BlockPos villagerHomePos = gVHP.func_218180_b();
                int deathX = (int)ve.func_226277_ct_();
                int deathY = (int)ve.func_226278_cu_();
                int deathZ = (int)ve.func_226281_cx_();
                eventEntity.func_70107_b((double)villagerHomePos.func_177958_n(), (double)villagerHomePos.func_177956_o(), (double)villagerHomePos.func_177952_p());
                ve.func_70066_B();
                ve.func_70606_j((float)MyConfig.respawnHealth);
                if (MyConfig.respawnXpLoss) {
                    int level = ve.func_213700_eh().func_221132_c();
                    ve.func_213702_q(xpLevels[level - 1]);
                }
                if (MyConfig.debugLevel > 0) {
                    System.out.println("VillagersRespawn: Villager " + deathMessage);
                    System.out.println(" at " + deathX + ", " + deathY + ", " + deathZ + ".");
                    System.out.println(" Respawned at " + ve.func_226277_ct_() + ", " + ve.func_226278_cu_() + ", " + ve.func_226281_cx_() + ".");
                }
                event.setCanceled(true);
            }
        }
    }
}

