/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.weaponthrow.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class WeaponThrowConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Server COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue notUseWhenCooldown;
        public final ForgeConfigSpec.BooleanValue creativeSpamming;
        public final ForgeConfigSpec.BooleanValue classicRender;
        public final ForgeConfigSpec.IntValue offsetY;
        public final ForgeConfigSpec.IntValue offsetX;
        public final ForgeConfigSpec.DoubleValue baseDamageDefault;
        public final ForgeConfigSpec.DoubleValue baseVelocityDefault;
        public final ForgeConfigSpec.DoubleValue pickaxeMultiplier;
        public final ForgeConfigSpec.DoubleValue axeMultiplier;
        public final ForgeConfigSpec.DoubleValue swordMultiplier;
        public final ForgeConfigSpec.DoubleValue hoeMultiplier;
        public final ForgeConfigSpec.DoubleValue shovelMultiplier;
        public final ForgeConfigSpec.DoubleValue baseDamageMultiplier;
        public final ForgeConfigSpec.DoubleValue stackDamageMultiplier;
        public final ForgeConfigSpec.DoubleValue modifiedDamageMultiplier;
        public final ForgeConfigSpec.DoubleValue baseVelocityMultiplier;
        public final ForgeConfigSpec.DoubleValue stackVelocityMultiplier;
        public final ForgeConfigSpec.DoubleValue modifiedVelocityMultiplier;
        public final ForgeConfigSpec.DoubleValue baseExhaustionMultiplier;
        public final ForgeConfigSpec.DoubleValue stackExhaustionMultiplier;
        public final ForgeConfigSpec.DoubleValue modifiedExhaustionMultiplier;
        public final ForgeConfigSpec.BooleanValue enablePMMOIntegration;
        public final ForgeConfigSpec.IntValue requiredCombatLoyalty;
        public final ForgeConfigSpec.BooleanValue enableItemPhysicsFix;
        public final ForgeConfigSpec.BooleanValue canBreakBlocks;
        public final ForgeConfigSpec.BooleanValue shouldThrowItemsToo;
        public final ForgeConfigSpec.BooleanValue enchantAll;
        public final ForgeConfigSpec.BooleanValue throwEnchant;
        public final ForgeConfigSpec.BooleanValue conccusionEnchant;
        public final ForgeConfigSpec.BooleanValue groundedEdgeEnchant;
        public final ForgeConfigSpec.BooleanValue gravityEnchant;
        public final ForgeConfigSpec.BooleanValue gravityDrop;
        public final ForgeConfigSpec.BooleanValue returnEnchant;
        public final ForgeConfigSpec.IntValue despawnTime;
        public final ForgeConfigSpec.IntValue castTimeInTicks;
        public final ForgeConfigSpec.IntValue ticksUntilWeaponLoseOwner;
        public final WhiteListedItems whiteList;
        public final BlackListedBlocks blackList;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Weapon Throw Mod Configuration Settings").push("general");
            this.notUseWhenCooldown = builder.comment("Weapon Cant be thrown if it is on cooldown").define("Not Throw If Cooldown", true);
            this.creativeSpamming = builder.comment("Weapons does not remove on creative").define("Creative Spamming", false);
            builder.pop();
            builder.comment("Client Settings").push("client");
            this.classicRender = builder.comment("If you got rendering problems, try enabling the old rendering").define("Use classic render", false);
            this.offsetY = builder.comment("Charging Y Hud Offset").defineInRange("Ycoord", 20, -32, 32);
            this.offsetX = builder.comment("Charging X Hud Offset").defineInRange("Xcoord", -8, -32, 32);
            builder.pop();
            builder.comment("If an item is whitelisted and doesn't have damage or attack speed, this values will be assigned").push("default");
            this.baseDamageDefault = builder.defineInRange("Default Base Damage", 1.0, 0.0, 256.0);
            this.baseVelocityDefault = builder.defineInRange("Default Base Velocity", 0.5, 0.0, 256.0);
            builder.pop();
            builder.push("enchantments");
            this.enchantAll = builder.comment("If this is enabled, all tools can be applied mod enchantments too").define("Enchant All", false);
            this.throwEnchant = builder.comment("Should Throw Enchantment be applied on survival?").define("Enable Throw Enchantment", true);
            this.conccusionEnchant = builder.comment("Should Conccusion Enchantment be applied on survival?").define("Enable Conccusion Enchantment", true);
            this.groundedEdgeEnchant = builder.comment("Should Grounded Edge Enchantment be applied on survival?").define("Enable Grounded Edge Enchantment", true);
            this.gravityEnchant = builder.comment("Should Gravity Enchantment be applied on survival?").define("Enable Gravity Enchantment", true);
            this.gravityDrop = builder.comment("Should gravity curse drop after some time?").define("Gravity Drop", false);
            this.returnEnchant = builder.comment("Should Return Enchantment be applied on survival?").define("Enable Return Enchantment", true);
            builder.pop();
            builder.push("experimental");
            this.shouldThrowItemsToo = builder.comment("Enable using all items as a weapon").define("Throw all items", false);
            builder.pop();
            builder.push("fixes");
            this.enableItemPhysicsFix = builder.comment("Disable this if theres tossing bugs").define("Item Physics Fix", true);
            builder.pop();
            builder.push("interactions");
            this.canBreakBlocks = builder.comment("Throwing can break blocks at landing?").define("Break Blocks", true);
            builder.pop();
            builder.push("multipliers");
            this.pickaxeMultiplier = builder.defineInRange("Pickaxe Multiplier", 0.2, 0.0, 256.0);
            this.axeMultiplier = builder.defineInRange("Axe Multiplier", 1.2, 0.0, 256.0);
            this.swordMultiplier = builder.defineInRange("Sword Multiplier", 1.0, 0.0, 256.0);
            this.hoeMultiplier = builder.defineInRange("Hoe Multiplier", 0.5, 0.0, 256.0);
            this.shovelMultiplier = builder.defineInRange("Shovel Multiplier", 0.7, 0.0, 256.0);
            this.baseDamageMultiplier = builder.defineInRange("Base Damage Multiplier", 0.25, 0.0, 256.0);
            this.stackDamageMultiplier = builder.defineInRange("Stack Size Damage Multiplier", 0.0, 0.0, 256.0);
            this.modifiedDamageMultiplier = builder.defineInRange("Modified Damage Multiplier", 0.5, 0.0, 256.0);
            this.baseVelocityMultiplier = builder.defineInRange("Base Velocity Multiplier", 0.25, 0.0, 64.0);
            this.stackVelocityMultiplier = builder.defineInRange("Stack Size Velocity Multiplier", 0.005, 0.0, 64.0);
            this.modifiedVelocityMultiplier = builder.defineInRange("Modified Velocity Multiplier", 0.4, 0.0, 64.0);
            this.baseExhaustionMultiplier = builder.defineInRange("Base Exhaustion Multiplier", 0.075, 0.0, 256.0);
            this.stackExhaustionMultiplier = builder.defineInRange("Stack Size Exhaustion Multiplier", 0.01, 0.0, 256.0);
            this.modifiedExhaustionMultiplier = builder.defineInRange("Modified Exhaustion Multiplier", 2.0, 0.0, 256.0);
            builder.pop();
            builder.comment("Integration with Project MMO").push("pmmo");
            this.enablePMMOIntegration = builder.comment("Disable this if running Minecraft 1.16.3 and below").define("Enable PMMO Integration", true);
            this.requiredCombatLoyalty = builder.comment("Minimum Level Required to use Loyalty, 0 is none").defineInRange("Loyalty Requirement", 10, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("time");
            this.despawnTime = builder.comment("Time in ticks when the throwed items should dissapear").defineInRange("Despawn Time", 1200, 0, Integer.MAX_VALUE);
            this.castTimeInTicks = builder.comment("Attack Speed Multiplier to charging").defineInRange("Charging Multiplier", 3, 0, Integer.MAX_VALUE);
            this.ticksUntilWeaponLoseOwner = builder.comment("Time in ticks when throwed items lose their owner").defineInRange("Lose Owner Time", 140, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("All Items Whitelisted will get default values").push("whitelist-items");
            this.whiteList = new WhiteListedItems(builder);
            builder.pop();
            builder.comment("All Blacklisted blocks cannot be destroyed").push("blacklist-blocks");
            this.blackList = new BlackListedBlocks(builder);
            builder.pop();
        }

        public class BlackListedBlocks {
            public final List<String> DEFAULT_BLACKLIST = Arrays.asList(Items.field_221598_z.getRegistryName().toString());
            public ForgeConfigSpec.ConfigValue<List<? extends String>> blackList;

            BlackListedBlocks(ForgeConfigSpec.Builder builder) {
                this.blackList = builder.defineList("Blacklisted blocks", this.DEFAULT_BLACKLIST, o -> o instanceof String);
            }

            public List<Block> get() {
                ArrayList<Block> items = new ArrayList<Block>();
                for (String location : (List)this.blackList.get()) {
                    ResourceLocation resourceLocation = new ResourceLocation(location);
                    if (!ForgeRegistries.BLOCKS.containsKey(resourceLocation)) continue;
                    items.add((Block)ForgeRegistries.BLOCKS.getValue(resourceLocation));
                }
                return items;
            }
        }

        public class WhiteListedItems {
            public final List<String> DEFAULT_WHITELIST = Arrays.asList(Items.field_151118_aC.getRegistryName().toString(), Items.field_221650_am.getRegistryName().toString());
            public ForgeConfigSpec.ConfigValue<List<? extends String>> whiteList;

            WhiteListedItems(ForgeConfigSpec.Builder builder) {
                this.whiteList = builder.defineList("Whitelisted items", this.DEFAULT_WHITELIST, o -> o instanceof String);
            }

            public List<Item> get() {
                ArrayList<Item> items = new ArrayList<Item>();
                for (String location : (List)this.whiteList.get()) {
                    ResourceLocation resourceLocation = new ResourceLocation(location);
                    if (!ForgeRegistries.ITEMS.containsKey(resourceLocation)) continue;
                    items.add((Item)ForgeRegistries.ITEMS.getValue(resourceLocation));
                }
                return items;
            }
        }
    }
}

