/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.wellbehavedmobs.common.element;

import com.fuzs.puzzleslib_wbm.config.ConfigManager;
import com.fuzs.puzzleslib_wbm.config.deserialize.EntryCollectionBuilder;
import com.fuzs.puzzleslib_wbm.element.AbstractElement;
import com.fuzs.puzzleslib_wbm.element.ISidedElement;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ScaredMonstersElement
extends AbstractElement
implements ISidedElement.Common {
    private Set<EntityType<?>> scaredMonsters;

    @Override
    public String getDescription() {
        return "Various monsters run from creepers about to explode.";
    }

    @Override
    public void setupCommon() {
        this.addListener(this::onEntityJoinWorld);
    }

    @Override
    public void setupCommonConfig(ForgeConfigSpec.Builder builder) {
        ScaredMonstersElement.addToConfig(builder.comment(new String[]{"Mobs that will run away from creepers about to explode.", EntryCollectionBuilder.CONFIG_STRING}).define("Scared Monster List", this.getMonsterList()), v -> {
            this.scaredMonsters = v;
        }, v -> new EntryCollectionBuilder<EntityType>(ForgeRegistries.ENTITIES).buildEntrySet((List<String>)v, type -> type.func_220339_d() != EntityClassification.MISC, "Not a living entity"));
    }

    private List<String> getMonsterList() {
        return ConfigManager.get().getKeyList((IForgeRegistryEntry[])new EntityType[]{EntityType.field_200797_k, EntityType.field_200741_ag, EntityType.field_200748_an, EntityType.field_200794_h, EntityType.field_200759_ay, EntityType.field_200725_aD, EntityType.field_200727_aF, EntityType.field_233592_ba_, EntityType.field_200763_C, EntityType.field_200750_ap, EntityType.field_200722_aA, EntityType.field_204724_o});
    }

    private void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        if (evt.getEntity() instanceof CreatureEntity && this.scaredMonsters.contains(evt.getEntity().func_200600_R())) {
            CreatureEntity creatureEntity = (CreatureEntity)evt.getEntity();
            creatureEntity.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal(creatureEntity, CreeperEntity.class, 4.0f, 1.0, 2.0, this::isAboutToExplode));
        }
    }

    private boolean isAboutToExplode(LivingEntity entity) {
        return entity instanceof CreeperEntity && (((CreeperEntity)entity).func_70832_p() > 0 || ((CreeperEntity)entity).func_146078_ca());
    }
}

