/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.cache;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import xaero.common.IXaeroMinimap;
import xaero.common.cache.placeholder.PlaceholderBlockGetter;

public class BlockStateShortShapeCache {
    private IXaeroMinimap modMain;
    private Map<BlockState, Boolean> shortBlockStates;
    private BlockState lastShortChecked = null;
    private boolean lastShortCheckedResult = false;
    private PlaceholderBlockGetter placeholderBlockGetter;

    public BlockStateShortShapeCache(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.shortBlockStates = new HashMap<BlockState, Boolean>();
        this.placeholderBlockGetter = new PlaceholderBlockGetter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShort(BlockState state) {
        Boolean cached;
        if (state == null || state.func_177230_c() instanceof AirBlock || state.func_177230_c() instanceof FlowingFluidBlock) {
            return false;
        }
        Map<BlockState, Boolean> map = this.shortBlockStates;
        synchronized (map) {
            if (state == this.lastShortChecked) {
                return this.lastShortCheckedResult;
            }
            cached = this.shortBlockStates.get(state);
        }
        if (cached == null) {
            if (!Minecraft.func_71410_x().func_213162_bc()) {
                return (Boolean)Minecraft.func_71410_x().func_213169_a(() -> this.isShort(state)).join();
            }
            try {
                this.placeholderBlockGetter.setPlaceholderState(state);
                VoxelShape shape = state.func_196954_c((IBlockReader)this.placeholderBlockGetter, BlockPos.field_177992_a);
                cached = shape.func_197758_c(Direction.Axis.Y) < 0.25;
            }
            catch (Throwable t) {
                this.modMain.getLogger().info("Defaulting world-dependent block state shape to not short: " + state);
                cached = false;
            }
            map = this.shortBlockStates;
            synchronized (map) {
                this.shortBlockStates.put(state, cached);
                this.lastShortChecked = state;
                this.lastShortCheckedResult = cached;
            }
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<BlockState, Boolean> map = this.shortBlockStates;
        synchronized (map) {
            this.shortBlockStates.clear();
            this.lastShortChecked = null;
            this.lastShortCheckedResult = false;
        }
    }
}

