/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.category.ObjectCategory;
import xaero.common.category.ui.GuiCategorySettings;
import xaero.common.category.ui.GuiCategoryUIEditorDataConverter;
import xaero.common.category.ui.data.GuiCategoryUIEditorCategoryData;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.data.GuiCategoryUIEditorSettingsData;
import xaero.common.category.ui.entry.CategorySettingsListEntry;
import xaero.common.category.ui.entry.CategorySettingsListMainEntry;
import xaero.common.category.ui.entry.ConnectionLineType;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiSettings;
import xaero.common.gui.ScreenBase;

public abstract class GuiCategorySettings<C extends ObjectCategory<?, C>, ED extends GuiCategoryUIEditorCategoryData<C, SD, ED>, CB extends ObjectCategory.Builder<C, CB>, SD extends GuiCategoryUIEditorSettingsData<?>, SDB extends GuiCategoryUIEditorSettingsData.Builder<SD, SDB>, EDB extends GuiCategoryUIEditorCategoryData.Builder<C, ED, SD, SDB, EDB>>
extends ScreenBase {
    private static final int FRAME_TOP_SIZE = 32;
    private static final int FRAME_BOTTOM_SIZE = 48;
    public static final int ROW_HEIGHT = 24;
    public static final int ROW_WIDTH = 220;
    private SettingRowList rowList;
    private final GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> dataConverter;
    private ED editorData;
    protected ED cutCategory;
    protected ED cutCategorySuper;

    protected GuiCategorySettings(IXaeroMinimap modMain, Screen parent, Screen escape, TextComponent title, GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> dataConverter) {
        super(modMain, parent, escape, (ITextComponent)title);
        this.dataConverter = dataConverter;
        this.editorData = this.constructEditorData(dataConverter);
    }

    protected abstract ED constructEditorData(GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract ED constructDefaultData(GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract void onConfigConfirmed(C var1);

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ - 32, 150, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_cancel", new Object[0]), b -> this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> {
            if (result) {
                super.onExit(this.parent);
            } else {
                this.field_230706_i_.func_147108_a((Screen)this);
            }
        }, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_cancel_confirm"), (ITextComponent)new StringTextComponent("")))));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ - 32, 150, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_confirm"), b -> this.confirm()));
        this.func_230480_a_((Widget)new Button(6, 6, 120, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_reset"), b -> this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> {
            if (result) {
                this.editorData = this.constructDefaultData(this.dataConverter);
            }
            this.field_230706_i_.func_147108_a((Screen)this);
        }, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_reset_confirm1"), (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_reset_confirm2")))));
        this.rowList = new SettingRowList(this.dataConverter);
        this.field_230705_e_.add(this.rowList);
    }

    private void confirm() {
        this.onConfigConfirmed(((ObjectCategory.Builder)this.dataConverter.getConfiguredBuilder(this.editorData)).build());
        super.onExit(this.parent);
    }

    @Override
    protected void onExit(Screen screen) {
        this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> {
            if (result) {
                this.confirm();
            }
            super.onExit(screen);
        }, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_save_confirm"), (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_save_confirm_warning")){

            public boolean func_231046_a_(int i, int j, int k) {
                if (i == 256) {
                    return true;
                }
                return super.func_231046_a_(i, j, k);
            }
        });
    }

    public void func_230430_a_(MatrixStack poseStack, int i, int j, float f) {
        this.rowList.func_230430_a_(poseStack, i, j, f);
        GuiSettings.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)5, (int)0xFFFFFF);
        super.func_230430_a_(poseStack, i, j, f);
        if (this.rowList.hovered != null) {
            CursorBox tooltip;
            poseStack.func_227860_a_();
            poseStack.func_227861_a_(0.0, 0.0, 0.1);
            Supplier<CursorBox> tooltipSupplier = this.rowList.hovered.getTooltipSupplier();
            if (tooltipSupplier != null && (tooltip = tooltipSupplier.get()) != null) {
                tooltip.drawBox(poseStack, i, j, this.field_230708_k_, this.field_230709_l_);
            }
            poseStack.func_227865_b_();
        }
    }

    public boolean func_231046_a_(int i, int j, int k) {
        if (this.rowList.func_230971_aw__() && i == 257 && this.rowList.confirmSelection()) {
            return true;
        }
        return super.func_231046_a_(i, j, k);
    }

    public void func_231023_e_() {
        this.rowList.tick();
        super.func_231023_e_();
    }

    public void func_231035_a_(IGuiEventListener guiEventListener) {
        super.func_231035_a_(guiEventListener);
        if (guiEventListener != null && guiEventListener == this.rowList) {
            this.rowList.narrateSelection();
        }
    }

    public SettingRowList getRowList() {
        return this.rowList;
    }

    public boolean func_231044_a_(double d, double e, int i) {
        if (super.func_231044_a_(d, e, i)) {
            return true;
        }
        return this.rowList.func_231044_a_(d, e, i);
    }

    public boolean func_231048_c_(double d, double e, int i) {
        if (super.func_231048_c_(d, e, i)) {
            return true;
        }
        return this.rowList.func_231048_c_(d, e, i);
    }

    public boolean func_231045_a_(double d, double e, int i, double f, double g) {
        if (super.func_231045_a_(d, e, i, f, g)) {
            return true;
        }
        return this.rowList.func_231045_a_(d, e, i, f, g);
    }

    public boolean func_231043_a_(double d, double e, double f) {
        if (super.func_231043_a_(d, e, f)) {
            return true;
        }
        return this.rowList.func_231043_a_(d, e, f);
    }

    public class SettingRowList
    extends ExtendedList<xaero.common.category.ui.GuiCategorySettings$SettingRowList.Entry> {
        private GuiCategoryUIEditorExpandableData<?> lastExpandedData;
        private boolean restoreScrollAfterUpdate;
        private CategorySettingsListEntry hovered;
        private final GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> dataConverter;

        public SettingRowList(GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> dataConverter) {
            super(GuiCategorySettings.this.field_230706_i_, GuiCategorySettings.this.field_230708_k_, GuiCategorySettings.this.field_230709_l_, 32, Math.max(36, GuiCategorySettings.this.field_230709_l_ - 48), 24);
            this.dataConverter = dataConverter;
            this.updateEntries();
            this.func_230943_a_(false);
        }

        public boolean hasCut() {
            if (GuiCategorySettings.this.cutCategory != null) {
                if (((GuiCategoryUIEditorCategoryData)GuiCategorySettings.this.cutCategorySuper).getSubCategories().contains(GuiCategorySettings.this.cutCategory)) {
                    return true;
                }
                this.setCutCategory(null, null);
            }
            return false;
        }

        public ED getCut() {
            return GuiCategorySettings.this.cutCategory;
        }

        public boolean isCut(ED category) {
            if (GuiCategorySettings.this.cutCategory == category) {
                return this.hasCut();
            }
            return false;
        }

        public void setCutCategory(ED cutCategory, ED cutCategorySuper) {
            GuiCategorySettings.this.cutCategory = cutCategory;
            GuiCategorySettings.this.cutCategorySuper = cutCategorySuper;
        }

        public void pasteTo(ED destination) {
            if (GuiCategorySettings.this.cutCategory != null) {
                if (destination == GuiCategorySettings.this.cutCategory || destination == GuiCategorySettings.this.cutCategorySuper) {
                    this.setCutCategory(null, null);
                    this.updateEntries();
                    return;
                }
                ((GuiCategoryUIEditorExpandableData)destination).getExpandAction(this).run();
                this.setLastExpandedData((GuiCategoryUIEditorExpandableData<?>)GuiCategorySettings.this.cutCategory);
                ((GuiCategoryUIEditorCategoryData)GuiCategorySettings.this.cutCategorySuper).getSubCategories().remove(GuiCategorySettings.this.cutCategory);
                ((GuiCategoryUIEditorCategoryData)destination).getSubCategories().add(0, GuiCategorySettings.this.cutCategory);
                this.setCutCategory(null, null);
            }
        }

        public boolean func_230971_aw__() {
            return GuiCategorySettings.this.func_241217_q_() == this;
        }

        public void setLastExpandedData(GuiCategoryUIEditorExpandableData<?> lastExpandedData) {
            this.lastExpandedData = lastExpandedData;
        }

        public void restoreScrollAfterUpdate() {
            this.restoreScrollAfterUpdate = true;
        }

        public void updateEntries() {
            double scrollBackup = this.func_230966_l_();
            this.func_230963_j_();
            GuiCategorySettings.this.editorData.setExpanded(true);
            this.addEntriesForExpandable(GuiCategorySettings.this.editorData, null);
            if (this.func_230958_g_() != null) {
                this.func_230951_c_(this.func_230958_g_());
            }
            if (this.restoreScrollAfterUpdate) {
                this.func_230932_a_(scrollBackup);
                this.restoreScrollAfterUpdate = false;
            }
        }

        private <D extends GuiCategoryUIEditorExpandableData<?>> void addEntriesForExpandable(GuiCategoryUIEditorExpandableData<D> data, GuiCategoryUIEditorExpandableData<?> parent) {
            int nextIndex = this.func_231039_at__().size();
            List<D> subExpandables = data.getSubExpandables();
            if (subExpandables == null) {
                return;
            }
            GuiCategoryUIEditorExpandableData expandedData = null;
            for (GuiCategoryUIEditorExpandableData sed : subExpandables) {
                if (!sed.isExpanded()) continue;
                expandedData = sed;
                break;
            }
            Entry currentEntry = new Entry(data.getListEntryFactory().get(data, parent, nextIndex, nextIndex == 0 ? ConnectionLineType.NONE : ConnectionLineType.PATH, this, this.field_230670_d_, expandedData == null), nextIndex++);
            this.func_230513_b_((AbstractList.AbstractListEntry)currentEntry);
            if (data == this.lastExpandedData) {
                this.setSelected(currentEntry);
            }
            if (expandedData != null) {
                this.addEntriesForExpandable(expandedData, data);
            } else {
                if (this.lastExpandedData == null && data.isExpanded()) {
                    this.setSelected(currentEntry);
                }
                boolean first = true;
                for (GuiCategoryUIEditorExpandableData sed : subExpandables) {
                    Entry leafEntry = new Entry(sed.getListEntryFactory().get(sed, data, nextIndex, first ? ConnectionLineType.HEAD_LEAF : ConnectionLineType.TAIL_LEAF, this, this.field_230670_d_, false), nextIndex++);
                    this.func_230513_b_((AbstractList.AbstractListEntry)leafEntry);
                    if (sed == this.lastExpandedData) {
                        this.setSelected(leafEntry);
                    }
                    first = false;
                }
            }
        }

        public boolean func_231044_a_(double d, double e, int i) {
            if (!this.func_231047_b_(d, e)) {
                this.setSelected(null);
            }
            return super.func_231044_a_(d, e, i);
        }

        public void func_212927_b(double d, double e) {
            if (this.func_230958_g_() != null) {
                ((Entry)this.func_230958_g_()).func_212927_b(d, e);
            }
            super.func_212927_b(d, e);
        }

        public boolean func_223281_a_(int i, int j, int k) {
            if (this.func_230958_g_() != null && ((Entry)this.func_230958_g_()).func_223281_a_(i, j, k)) {
                return true;
            }
            return super.func_223281_a_(i, j, k);
        }

        public boolean func_231042_a_(char c, int i) {
            boolean result;
            if (this.func_230958_g_() != null && (result = ((Entry)this.func_230958_g_()).func_231042_a_(c, i))) {
                return true;
            }
            return super.func_231042_a_(c, i);
        }

        public void tick() {
            if (this.func_230958_g_() != null) {
                ((Entry)this.func_230958_g_()).tick();
            }
        }

        public boolean confirmSelection() {
            CategorySettingsListEntry selectedSubEntry;
            Entry entry = (Entry)this.func_230958_g_();
            return entry != null && (selectedSubEntry = entry.wrappedEntry.confirmSelection()) != null;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public void setSelected(Entry entry) {
            if (this.func_230958_g_() != null) {
                ((Entry)this.func_230958_g_()).wrappedEntry.unfocusRecursively();
            }
            if (this.func_241217_q_() != null) {
                ((Entry)this.func_241217_q_()).func_231049_c__(false);
            }
            if (entry != null) {
                entry.wrappedEntry.focusFirstRecursively();
            }
            super.func_241215_a_((AbstractList.AbstractListEntry)entry);
            super.func_231035_a_((IGuiEventListener)entry);
            this.narrateSelection();
        }

        public void func_231035_a_(IGuiEventListener guiEventListener) {
        }

        public int func_230949_c_() {
            return this.field_230670_d_;
        }

        protected int func_230952_d_() {
            return this.field_230670_d_ / 2 + 164;
        }

        public void narrateSelection() {
            if (!this.func_230971_aw__()) {
                return;
            }
            Entry entry = (Entry)this.func_230958_g_();
            if (entry == null) {
                return;
            }
            String selectedNarrationString = entry.wrappedEntry.getSelectedNarration();
            if (selectedNarrationString == null || selectedNarrationString.isEmpty()) {
                return;
            }
            String narration = entry == null ? I18n.func_135052_a((String)"gui.xaero_narrator_select_nothing", (Object[])new Object[0]) : selectedNarrationString;
            NarratorChatListener.field_193643_a.func_216864_a(I18n.func_135052_a((String)"narrator.select", (Object[])new Object[]{narration}) + " . " + I18n.func_135052_a((String)"narration.xaero_ui_list_left_right_usage", (Object[])new Object[0]));
        }

        public void func_230430_a_(MatrixStack poseStack, int i, int j, float f) {
            this.hovered = null;
            super.func_230430_a_(poseStack, i, j, f);
        }

        public GuiCategoryUIEditorDataConverter<C, ED, CB, SD, SDB, EDB> getDataConverter() {
            return this.dataConverter;
        }

        public class Entry
        extends ExtendedList.AbstractListEntry<xaero.common.category.ui.GuiCategorySettings$SettingRowList.Entry> {
            private CategorySettingsListMainEntry<?> wrappedEntry;
            private int index;
            private int lastX;
            private int lastY;

            public Entry(CategorySettingsListMainEntry<?> entryInfo, int index) {
                this.wrappedEntry = entryInfo;
                this.index = index;
            }

            public void func_230432_a_(MatrixStack poseStack, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                this.lastX = x;
                this.lastY = y;
                poseStack.func_227860_a_();
                poseStack.func_227861_a_((double)x, (double)y, 0.0);
                boolean includesSelected = SettingRowList.this.func_230958_g_() == this;
                this.wrappedEntry.preRender(poseStack, includesSelected, true);
                CategorySettingsListEntry hoveredInRow = this.wrappedEntry.render(poseStack, index, rowWidth, rowHeight, mouseX - x - this.wrappedEntry.getEntryRelativeX(), mouseY - y - this.wrappedEntry.getEntryRelativeY(), isMouseOver, partialTicks, GuiCategorySettings.this.field_230712_o_, mouseX, mouseY, includesSelected, true);
                this.wrappedEntry.postRender(poseStack);
                poseStack.func_227865_b_();
                if (hoveredInRow != null) {
                    SettingRowList.this.hovered = hoveredInRow;
                }
            }

            public boolean func_231044_a_(double mouseX, double mouseY, int i) {
                SettingRowList.this.setSelected(this);
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                double relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY();
                this.wrappedEntry.mouseClicked(this, relativeMouseX, relativeMouseY, i);
                return true;
            }

            public boolean func_231048_c_(double mouseX, double mouseY, int i) {
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                double relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY();
                this.wrappedEntry.mouseReleased(relativeMouseX, relativeMouseY, i);
                return super.func_231048_c_(mouseX, mouseY, i);
            }

            public boolean func_231043_a_(double mouseX, double mouseY, double f) {
                double relativeMouseY;
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                if (this.wrappedEntry.mouseScrolled(relativeMouseX, relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY(), f)) {
                    return true;
                }
                return super.func_231043_a_(mouseX, mouseY, f);
            }

            public boolean func_231045_a_(double mouseX, double mouseY, int i, double f, double g) {
                double relativeMouseY;
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                if (this.wrappedEntry.mouseDragged(relativeMouseX, relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY(), i, f, g)) {
                    return true;
                }
                return super.func_231045_a_(mouseX, mouseY, i, f, g);
            }

            public boolean func_231046_a_(int i, int j, int k) {
                if (this.wrappedEntry.keyPressed(i, j, k, true)) {
                    return true;
                }
                return super.func_231046_a_(i, j, k);
            }

            public boolean func_223281_a_(int i, int j, int k) {
                if (this.wrappedEntry.keyReleased(i, j, k)) {
                    return true;
                }
                return super.func_223281_a_(i, j, k);
            }

            public boolean func_231042_a_(char c, int i) {
                if (this.wrappedEntry.charTyped(c, i)) {
                    return true;
                }
                return super.func_231042_a_(c, i);
            }

            public void func_212927_b(double d, double e) {
                this.wrappedEntry.mouseMoved(d, e);
                super.func_212927_b(d, e);
            }

            public boolean func_231049_c__(boolean bl) {
                this.wrappedEntry.changeFocus(bl);
                return super.func_231049_c__(bl);
            }

            public void tick() {
                this.wrappedEntry.tick();
            }
        }
    }
}

