/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics.renderer.multitexture;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;
import java.util.function.IntConsumer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class MultiTextureRenderTypeRenderer {
    private boolean used;
    private BufferBuilder bufferBuilder = new BufferBuilder(256);
    private IntArrayList texturesForDrawCalls = new IntArrayList();
    private IntConsumer textureBinder;
    private int prevTextureId;
    private VertexFormat prevFormat;
    private RenderType renderType;

    MultiTextureRenderTypeRenderer() {
    }

    void init(IntConsumer textureBinder, RenderType renderType) {
        if (this.used) {
            throw new IllegalStateException("Multi-texture renderer already in use!");
        }
        this.used = true;
        this.textureBinder = textureBinder;
        this.prevTextureId = -1;
        this.renderType = renderType;
    }

    void draw() {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (!this.texturesForDrawCalls.isEmpty()) {
            BufferBuilder bufferBuilder = this.bufferBuilder;
            IntConsumer textureBinder = this.textureBinder;
            this.renderType.func_228547_a_();
            bufferBuilder.func_178977_d();
            for (Integer texture : this.texturesForDrawCalls) {
                textureBinder.accept(texture);
                WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
            }
            textureBinder.accept(0);
            this.renderType.func_228549_b_();
        }
        this.texturesForDrawCalls.clear();
        this.used = false;
        this.renderType = null;
    }

    public BufferBuilder begin(int mode, VertexFormat format, int textureId) {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (textureId == -1) {
            throw new IllegalStateException("Attempted to use the multi-texture renderer with texture id -1!");
        }
        if (textureId != this.prevTextureId || !Objects.equals(this.prevFormat, format)) {
            if (this.prevTextureId != -1) {
                this.bufferBuilder.func_178977_d();
            }
            this.bufferBuilder.func_181668_a(mode, format);
            this.prevTextureId = textureId;
            this.prevFormat = format;
            this.texturesForDrawCalls.add(textureId);
        }
        return this.bufferBuilder;
    }
}

