/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.base.Objects;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.ConfigSettingEntry;
import xaero.common.gui.ISettingEntry;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.widget.WidgetScreen;
import xaero.common.misc.KeySortableByOther;
import xaero.common.misc.Misc;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public abstract class GuiSettings
extends ScreenBase
implements WidgetScreen {
    protected int entriesPerPage = 12;
    protected ISettingEntry[] entries;
    protected String entryFilter = "";
    private boolean foundSomething;
    protected ITextComponent screenTitle;
    protected int page;
    protected int maxPage;
    private MyTinyButton nextButton;
    private MyTinyButton prevButton;
    private TextFieldWidget searchField;
    protected boolean canSearch = true;
    private boolean shouldRefocusSearch;

    public GuiSettings(IXaeroMinimap modMain, TextComponent title, Screen backScreen, Screen escScreen) {
        super(modMain, backScreen, escScreen, (ITextComponent)title);
    }

    public void func_231160_c_() {
        int verticalOffset;
        super.func_231160_c_();
        this.screenTitle = this.field_230704_d_;
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 6 + 168, 200, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_back", new Object[0]), b -> this.goBack()));
        int n = verticalOffset = this.canSearch ? 24 : 0;
        if (this.entries != null) {
            boolean canEditIngameSettings = ModSettings.canEditIngameSettings();
            ArrayList<KeySortableByOther<ISettingEntry>> sortingList = new ArrayList<KeySortableByOther<ISettingEntry>>();
            String comparisonFilter = this.entryFilter.toLowerCase();
            for (int i = 0; i < this.entries.length; ++i) {
                int positionInEntryString;
                ISettingEntry entry = this.entries[i];
                String entrySearchString = entry.getStringForSearch(this.field_230706_i_.field_71474_y).toLowerCase();
                if (entrySearchString == null || (positionInEntryString = entrySearchString.indexOf(comparisonFilter)) == -1) continue;
                KeySortableByOther<ISettingEntry> sortableEntry = new KeySortableByOther<ISettingEntry>(entry, Integer.valueOf(positionInEntryString));
                sortingList.add(sortableEntry);
            }
            ArrayList filteredEntries = sortingList.stream().sorted().map(KeySortableByOther::getKey).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            if (!filteredEntries.isEmpty()) {
                this.foundSomething = true;
                this.maxPage = (int)Math.ceil((double)filteredEntries.size() / (double)this.entriesPerPage) - 1;
                if (this.page > this.maxPage) {
                    this.page = this.maxPage;
                }
                int firstEntry = this.entriesPerPage * this.page;
                int entryCount = Math.min(filteredEntries.size() - firstEntry, this.entriesPerPage);
                for (int i = 0; i < entryCount; ++i) {
                    ISettingEntry entry = (ISettingEntry)filteredEntries.get(firstEntry + i);
                    Widget optionWidget = entry.createWidget(this.field_230706_i_.field_71474_y, this.field_230708_k_ / 2 - 205 + i % 2 * 210, this.field_230709_l_ / 7 + verticalOffset + 24 * (i >> 1), 200, canEditIngameSettings);
                    this.func_230480_a_(optionWidget);
                }
            } else {
                this.foundSomething = false;
                this.page = 0;
                this.maxPage = 0;
            }
        }
        this.screenTitle = this.screenTitle.func_230531_f_().func_240702_b_(" (" + (this.page + 1) + "/" + (this.maxPage + 1) + ")");
        this.nextButton = new MyTinyButton(this.field_230708_k_ / 2 + 131, this.field_230709_l_ / 7 + 144 + verticalOffset, (ITextComponent)new TranslationTextComponent("gui.xaero_next", new Object[0]), b -> this.onNextButton());
        this.prevButton = new MyTinyButton(this.field_230708_k_ / 2 - 205, this.field_230709_l_ / 7 + 144 + verticalOffset, (ITextComponent)new TranslationTextComponent("gui.xaero_previous", new Object[0]), b -> this.onPrevButton());
        if (this.maxPage > 0) {
            this.func_230480_a_((Widget)this.nextButton);
            this.func_230480_a_((Widget)this.prevButton);
            this.nextButton.field_230693_o_ = this.page < this.maxPage;
            this.prevButton.field_230693_o_ = this.page > 0;
        }
        this.modMain.getWidgetScreenHandler().initialize(this, this.field_230708_k_, this.field_230709_l_);
        if (this.canSearch) {
            boolean shouldFocusSearch = this.shouldRefocusSearch;
            this.shouldRefocusSearch = false;
            int cursorPos = 0;
            if (shouldFocusSearch) {
                cursorPos = this.searchField.func_146198_h();
            }
            this.searchField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 7, 200, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_settings_search"));
            this.searchField.func_146180_a(this.entryFilter);
            if (shouldFocusSearch) {
                this.func_231035_a_((IGuiEventListener)this.searchField);
                this.searchField.func_146195_b(true);
                this.searchField.func_212422_f(cursorPos);
                this.searchField.func_146199_i(cursorPos);
            }
            this.field_230705_e_.add(this.searchField);
        }
        this.field_230706_i_.field_195559_v.func_197967_a(true);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.canSearch) {
            this.searchField.func_146178_a();
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        this.func_230446_a_(matrixStack);
        this.modMain.getWidgetScreenHandler().render(matrixStack, this, this.field_230708_k_, this.field_230709_l_, par1, par2, this.field_230706_i_.func_228018_at_().func_198100_s());
        AbstractGui.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)this.screenTitle, (int)(this.field_230708_k_ / 2), (int)5, (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, par1, par2, par3);
        if (this.canSearch) {
            if (!this.foundSomething) {
                GuiSettings.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.xaero_settings_not_found", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 7 + 29), (int)0xFFFFFF);
            }
            if (!this.searchField.func_230999_j_() && this.searchField.func_146179_b().isEmpty()) {
                Misc.setFieldText(this.searchField, I18n.func_135052_a((String)"gui.xaero_settings_search_placeholder", (Object[])new Object[0]), -11184811);
                this.searchField.func_146190_e(0);
            }
            this.searchField.func_230430_a_(matrixStack, par1, par2, par3);
            if (!this.searchField.func_230999_j_()) {
                Misc.setFieldText(this.searchField, this.entryFilter);
            }
        }
        this.renderTooltips(matrixStack, par1, par2, par3);
    }

    public void restoreFocus(int index) {
        if (index != -1) {
            try {
                IGuiEventListener child = (IGuiEventListener)this.field_230705_e_.get(index);
                this.func_231035_a_(child);
                child.func_231049_c__(true);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public int getIndex(IGuiEventListener child) {
        for (int i = 0; i < this.field_230705_e_.size(); ++i) {
            if (this.field_230705_e_.get(i) != child) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addButtonVisible(Widget button) {
        this.func_230480_a_(button);
    }

    @Override
    public <S extends Screen> S getScreen() {
        return (S)this;
    }

    @Override
    protected void onExit(Screen screen) {
        try {
            this.modMain.getSettings().saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.onExit(screen);
    }

    public boolean func_231046_a_(int par1, int par2, int par3) {
        if (!(super.func_231046_a_(par1, par2, par3) || this.func_241217_q_() instanceof TextFieldWidget && ((TextFieldWidget)this.func_241217_q_()).func_230999_j_())) {
            if (Misc.inputMatchesKeyBinding(InputMappings.Type.KEYSYM, par1, (KeyBinding)this.modMain.getSettingsKey())) {
                this.func_231175_as__();
                return true;
            }
            return false;
        }
        if (this.canSearch) {
            this.updateSearch();
        }
        return true;
    }

    public boolean func_231042_a_(char c, int i) {
        boolean result = super.func_231042_a_(c, i);
        if (this.canSearch) {
            this.updateSearch();
        }
        return result;
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.modMain.getWidgetScreenHandler().handleClick(this, this.field_230708_k_, this.field_230709_l_, (int)p_mouseClicked_1_, (int)p_mouseClicked_3_, this.field_230706_i_.func_228018_at_().func_198100_s());
        if (!super.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
            if (Misc.inputMatchesKeyBinding(InputMappings.Type.MOUSE, p_mouseClicked_5_, (KeyBinding)this.modMain.getSettingsKey())) {
                this.goBack();
                return true;
            }
            return false;
        }
        return true;
    }

    protected void onNextButton() {
        ++this.page;
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    protected void onPrevButton() {
        --this.page;
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    protected static ISettingEntry[] entriesFromOptions(ModOptions[] options) {
        ISettingEntry[] result = new ISettingEntry[options.length];
        for (int i = 0; i < options.length; ++i) {
            result[i] = new ConfigSettingEntry(options[i]);
        }
        return result;
    }

    protected void resetConfirmResult(boolean result, Screen parent, Screen escScreen) {
        if (result) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                minimapSession.getMinimapProcessor().setToResetImage(true);
            }
            try {
                this.modMain.resetSettings();
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().resetEntityIcons();
        }
        this.modMain.getGuiHelper().onResetCancel(parent, escScreen);
    }

    public ISettingEntry[] getEntriesCopy() {
        if (this.entries == null) {
            return null;
        }
        ISettingEntry[] result = new ISettingEntry[this.entries.length];
        System.arraycopy(this.entries, 0, result, 0, this.entries.length);
        return result;
    }

    public void func_231035_a_(IGuiEventListener guiEventListener) {
        IGuiEventListener currentFocused = this.func_241217_q_();
        if (currentFocused != guiEventListener && currentFocused instanceof TextFieldWidget) {
            ((TextFieldWidget)currentFocused).func_146195_b(false);
        }
        super.func_231035_a_(guiEventListener);
    }

    private void updateSearch() {
        String newValue;
        if (this.searchField.func_230999_j_() && !Objects.equal((Object)this.entryFilter, (Object)(newValue = this.searchField.func_146179_b()))) {
            this.entryFilter = this.searchField.func_146179_b();
            this.shouldRefocusSearch = true;
            this.page = 0;
            this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        }
    }
}

