/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;

public class RenderUtils {
    private static final RenderType LINES = RenderType.func_228632_a_((String)"supermartijn642corelib:lines", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)128, (RenderType.State)RenderTypeExtension.getLinesState());
    private static final RenderType LINES_NO_DEPTH = RenderType.func_228632_a_((String)"supermartijn642corelib:lines_no_depth", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)128, (RenderType.State)RenderTypeExtension.getLinesStateNoDepth());
    private static final RenderType QUADS = RenderType.func_228632_a_((String)"supermartijn642corelib:quads", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)128, (RenderType.State)RenderTypeExtension.getQuadState());
    private static final RenderType QUADS_NO_DEPTH = RenderType.func_228632_a_((String)"supermartijn642corelib:quads_no_depth", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)128, (RenderType.State)RenderTypeExtension.getQuadStateNoDepth());
    private static boolean depthTest = true;

    public static void enableDepthTest() {
        depthTest = true;
    }

    public static void disableDepthTest() {
        depthTest = false;
    }

    public static void resetState() {
        depthTest = true;
    }

    public static Vector3d getCameraPosition() {
        return ClientUtils.getMinecraft().func_175598_ae().field_217783_c.func_216785_c();
    }

    public static IRenderTypeBuffer.Impl getMainBufferSource() {
        return ClientUtils.getMinecraft().func_228019_au_().func_228487_b_();
    }

    public static void renderShape(MatrixStack matrixStack, BlockShape shape, float red, float green, float blue, float alpha) {
        IVertexBuilder builder = RenderUtils.getMainBufferSource().getBuffer(depthTest ? LINES : LINES_NO_DEPTH);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        shape.forEachEdge((x1, y1, z1, x2, y2, z2) -> {
            builder.func_227888_a_(matrix4f, (float)x1, (float)y1, (float)z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix4f, (float)x2, (float)y2, (float)z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        });
        RenderUtils.getMainBufferSource().func_228461_a_();
    }

    public static void renderShapeSides(MatrixStack matrixStack, BlockShape shape, float red, float green, float blue, float alpha) {
        IVertexBuilder builder = RenderUtils.getMainBufferSource().getBuffer(depthTest ? QUADS : QUADS_NO_DEPTH);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        shape.forEachBox(box -> {
            float minX = (float)box.field_72340_a;
            float maxX = (float)box.field_72336_d;
            float minY = (float)box.field_72338_b;
            float maxY = (float)box.field_72337_e;
            float minZ = (float)box.field_72339_c;
            float maxZ = (float)box.field_72334_f;
            builder.func_227888_a_(matrix, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        });
        RenderUtils.getMainBufferSource().func_228461_a_();
    }

    public static void renderShape(MatrixStack poseStack, VoxelShape shape, float red, float green, float blue, float alpha) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, alpha);
    }

    public static void renderShapeSides(MatrixStack poseStack, VoxelShape shape, float red, float green, float blue, float alpha) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, alpha);
    }

    public static void renderBox(MatrixStack poseStack, AxisAlignedBB box, float red, float green, float blue, float alpha) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, alpha);
    }

    public static void renderBoxSides(MatrixStack poseStack, AxisAlignedBB box, float red, float green, float blue, float alpha) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, alpha);
    }

    public static void renderShape(MatrixStack poseStack, BlockShape shape, float red, float green, float blue) {
        RenderUtils.renderShape(poseStack, shape, red, green, blue, 1.0f);
    }

    public static void renderShapeSides(MatrixStack poseStack, BlockShape shape, float red, float green, float blue) {
        RenderUtils.renderShapeSides(poseStack, shape, red, green, blue, 1.0f);
    }

    public static void renderShape(MatrixStack poseStack, VoxelShape shape, float red, float green, float blue) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, 1.0f);
    }

    public static void renderShapeSides(MatrixStack poseStack, VoxelShape shape, float red, float green, float blue) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, 1.0f);
    }

    public static void renderBox(MatrixStack poseStack, AxisAlignedBB box, float red, float green, float blue) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, 1.0f);
    }

    public static void renderBoxSides(MatrixStack poseStack, AxisAlignedBB box, float red, float green, float blue) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, 1.0f);
    }

    private static class RenderTypeExtension
    extends RenderType {
        private static final RenderState.DepthTestState NO_DEPTH_TEST = new RenderState.DepthTestState("always", 519){

            public void func_228547_a_() {
                RenderSystem.disableDepthTest();
                super.func_228547_a_();
            }
        };

        public RenderTypeExtension(String p_i225992_1_, VertexFormat p_i225992_2_, int p_i225992_3_, int p_i225992_4_, boolean p_i225992_5_, boolean p_i225992_6_, Runnable p_i225992_7_, Runnable p_i225992_8_) {
            super(p_i225992_1_, p_i225992_2_, p_i225992_3_, p_i225992_4_, p_i225992_5_, p_i225992_6_, p_i225992_7_, p_i225992_8_);
        }

        public static RenderType.State getLinesState() {
            return RenderType.State.func_228694_a_().func_228713_a_(field_228517_i_).func_228720_a_(field_228506_P_).func_228726_a_(field_228515_g_).func_228718_a_(field_239235_M_).func_228714_a_(field_228491_A_).func_228715_a_(field_228494_D_).func_228727_a_(field_228496_F_).func_228728_a_(false);
        }

        public static RenderType.State getLinesStateNoDepth() {
            return RenderType.State.func_228694_a_().func_228713_a_(field_228517_i_).func_228720_a_(field_228506_P_).func_228726_a_(field_228515_g_).func_228718_a_(field_239235_M_).func_228714_a_(field_228491_A_).func_228715_a_(NO_DEPTH_TEST).func_228727_a_(field_228496_F_).func_228728_a_(false);
        }

        public static RenderType.State getQuadState() {
            return RenderType.State.func_228694_a_().func_228713_a_(field_228517_i_).func_228726_a_(field_228515_g_).func_228724_a_(field_228523_o_).func_228714_a_(field_228491_A_).func_228715_a_(field_228494_D_).func_228727_a_(field_228496_F_).func_228728_a_(false);
        }

        public static RenderType.State getQuadStateNoDepth() {
            return RenderType.State.func_228694_a_().func_228713_a_(field_228517_i_).func_228726_a_(field_228515_g_).func_228724_a_(field_228523_o_).func_228714_a_(field_228491_A_).func_228715_a_(NO_DEPTH_TEST).func_228727_a_(field_228496_F_).func_228728_a_(false);
        }
    }
}

