/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

public class LanternRecipeProvider
extends RecipeProvider {
    public LanternRecipeProvider(GatherDataEvent e) {
        super(e.getGenerator());
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> recipeConsumer) {
        for (LanternMaterial material : LanternMaterial.values()) {
            LanternRecipeProvider.addMaterialRecipes(material, recipeConsumer);
        }
    }

    private static void addMaterialRecipes(LanternMaterial material, Consumer<IFinishedRecipe> recipeConsumer) {
        LanternRecipeProvider.addLanternRecipe(material, recipeConsumer);
        if (material.canBeColored) {
            LanternRecipeProvider.addColorRecipe(material, null, recipeConsumer);
            for (LanternColor color : LanternColor.values()) {
                LanternRecipeProvider.addColorRecipe(material, color, recipeConsumer);
            }
        }
        if (material.hasChains) {
            LanternRecipeProvider.addChainRecipe(material, recipeConsumer);
        }
    }

    private static void addLanternRecipe(LanternMaterial material, Consumer<IFinishedRecipe> recipeConsumer) {
        if (material.primaryLanternIngredient == null && material.secondaryLanternIngredient == null) {
            return;
        }
        if (material.primaryLanternIngredient == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)material.getLanternBlock()).func_200472_a("B B").func_200472_a(" C ").func_200472_a("B B").func_200462_a(Character.valueOf('B'), material.secondaryLanternIngredient).func_200462_a(Character.valueOf('C'), () -> Items.field_221657_bQ).func_200465_a("has_torch", (ICriterionInstance)LanternRecipeProvider.func_200403_a(() -> Items.field_221657_bQ)).func_200464_a(recipeConsumer);
        } else if (material.secondaryLanternIngredient == null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)material.getLanternBlock()).func_200472_a(" A ").func_200472_a("ACA").func_200472_a(" A ").func_200462_a(Character.valueOf('A'), material.primaryLanternIngredient).func_200462_a(Character.valueOf('C'), () -> Items.field_221657_bQ).func_200465_a("has_torch", (ICriterionInstance)LanternRecipeProvider.func_200403_a(() -> Items.field_221657_bQ)).func_200464_a(recipeConsumer);
        } else {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)material.getLanternBlock()).func_200472_a("BAB").func_200472_a("ACA").func_200472_a("BAB").func_200462_a(Character.valueOf('A'), material.primaryLanternIngredient).func_200462_a(Character.valueOf('B'), material.secondaryLanternIngredient).func_200462_a(Character.valueOf('C'), () -> Items.field_221657_bQ).func_200465_a("has_torch", (ICriterionInstance)LanternRecipeProvider.func_200403_a(() -> Items.field_221657_bQ)).func_200464_a(recipeConsumer);
        }
    }

    private static void addColorRecipe(LanternMaterial material, LanternColor color, Consumer<IFinishedRecipe> recipeConsumer) {
        if (color == null) {
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)material.getLanternBlock()).func_203221_a(LanternRecipeProvider.getMaterialLanternTag(material)).func_200483_a("has_lantern", (ICriterionInstance)LanternRecipeProvider.func_200409_a(LanternRecipeProvider.getMaterialLanternTag(material))).func_200485_a(recipeConsumer, new ResourceLocation("additionallanterns", material.getSuffix() + "_lantern_colorless"));
        } else {
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)material.getLanternBlock(color)).func_203221_a(LanternRecipeProvider.getMaterialLanternTag(material)).func_203221_a(LanternRecipeProvider.getColorDyeTag(color)).func_200483_a("has_lantern", (ICriterionInstance)LanternRecipeProvider.func_200409_a(LanternRecipeProvider.getMaterialLanternTag(material))).func_200485_a(recipeConsumer, new ResourceLocation("additionallanterns", material.getSuffix() + "_lantern_" + color.getSuffix()));
        }
    }

    private static ITag<Item> getMaterialLanternTag(LanternMaterial material) {
        return TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation("additionallanterns", material.getSuffix() + "_lanterns"));
    }

    private static ITag<Item> getColorDyeTag(LanternColor color) {
        return color.dyeColor.getTag();
    }

    private static void addChainRecipe(LanternMaterial material, Consumer<IFinishedRecipe> recipeConsumer) {
        if (material.primaryChainIngredient == null && material.secondaryChainIngredient == null) {
            return;
        }
        if (material.primaryChainIngredient == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)material.getChainBlock(), (int)material.chainRecipeCount).func_200472_a("B").func_200472_a(" ").func_200472_a("B").func_200462_a(Character.valueOf('B'), material.secondaryChainIngredient).func_200465_a("has_secondary", (ICriterionInstance)LanternRecipeProvider.func_200403_a((IItemProvider)material.secondaryChainIngredient)).func_200464_a(recipeConsumer);
        } else if (material.secondaryChainIngredient == null) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)material.getChainBlock(), (int)material.chainRecipeCount).func_200472_a("A").func_200462_a(Character.valueOf('A'), material.primaryChainIngredient).func_200465_a("has_primary", (ICriterionInstance)LanternRecipeProvider.func_200403_a((IItemProvider)material.primaryChainIngredient)).func_200464_a(recipeConsumer);
        } else {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)material.getChainBlock(), (int)material.chainRecipeCount).func_200472_a("B").func_200472_a("A").func_200472_a("B").func_200462_a(Character.valueOf('A'), material.primaryChainIngredient).func_200462_a(Character.valueOf('B'), material.secondaryChainIngredient).func_200465_a("has_primary", (ICriterionInstance)LanternRecipeProvider.func_200403_a((IItemProvider)material.primaryChainIngredient)).func_200464_a(recipeConsumer);
        }
    }
}

