/*
 * Decompiled with CFR 0.152.
 */
package com.loucaskreger.automaticelytra.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CEntityActionPacket;
import net.minecraft.potion.Effects;
import net.minecraft.util.NonNullList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPlayerEntity.class})
public class ClientPlayerEntityMixin {
    private static final int CHESTPLATE_INDEX = 6;
    private int lastIndex = -1;

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/entity/player/ClientPlayerEntity;getItemBySlot(Lnet/minecraft/inventory/EquipmentSlotType;)Lnet/minecraft/item/ItemStack;")})
    private void onPlayerTickMovement(CallbackInfo ci) {
        ClientPlayerEntity player = (ClientPlayerEntity)this;
        PlayerController pc = Minecraft.func_71410_x().field_71442_b;
        if (!(player.func_233570_aj_() || player.func_184613_cA() || player.func_70644_a(Effects.field_188424_y))) {
            this.equipElytra(player, pc);
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="TAIL")})
    private void endTickMovement(CallbackInfo ci) {
        ClientPlayerEntity player = (ClientPlayerEntity)this;
        PlayerController pc = Minecraft.func_71410_x().field_71442_b;
        if (player.func_233570_aj_() || player.func_70090_H()) {
            player.func_226566_ei_();
            if (this.lastIndex != -1) {
                pc.func_187098_a(player.field_71070_bA.field_75152_c, 6, this.lastIndex, ClickType.SWAP, (PlayerEntity)player);
                this.lastIndex = -1;
            }
        }
    }

    private void equipElytra(ClientPlayerEntity player, PlayerController pc) {
        int firstElytraIndex = this.getElytraIndex(player);
        if (firstElytraIndex != -1) {
            this.lastIndex = firstElytraIndex;
            pc.func_187098_a(player.field_71070_bA.field_75152_c, 6, firstElytraIndex, ClickType.SWAP, (PlayerEntity)player);
            player.field_71174_a.func_147297_a((IPacket)new CEntityActionPacket((Entity)player, CEntityActionPacket.Action.START_FALL_FLYING));
        }
    }

    private int getElytraIndex(ClientPlayerEntity player) {
        NonNullList inv = player.field_71071_by.field_70462_a;
        for (int i = 0; i < inv.size(); ++i) {
            if (((ItemStack)inv.get(i)).func_77973_b() != Items.field_185160_cR) continue;
            return i;
        }
        return -1;
    }
}

