/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.ButtonStates;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Buttons;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.Mappings;
import com.mrcrayfish.controllable.client.gui.ControllerAxis;
import com.mrcrayfish.controllable.client.gui.ControllerButton;
import com.mrcrayfish.controllable.client.gui.ThumbstickSettingsScreen;
import com.mrcrayfish.controllable.client.gui.widget.ImageButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ControllerLayoutScreen
extends Screen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("controllable", "textures/gui/controller.png");
    private List<ControllerButton> controllerButtons = new ArrayList<ControllerButton>();
    private int configureButton = -1;
    private boolean validLayout;
    private Screen parentScreen;
    private LayoutButtonStates states = new LayoutButtonStates();
    private Mappings.Entry entry;
    private Button doneButton;
    private Button resetButton;
    private Button thumbstickButton;

    protected ControllerLayoutScreen(Screen parentScreen) {
        super((ITextComponent)new TranslationTextComponent("controllable.gui.title.layout"));
        this.parentScreen = parentScreen;
        Controller controller = Controllable.getController();
        if (controller != null) {
            Mappings.Entry entry = controller.getMapping();
            this.entry = entry != null ? entry.copy() : new Mappings.Entry(controller.getName(), controller.getName(), new HashMap<Integer, Integer>());
        }
    }

    protected void func_231160_c_() {
        this.controllerButtons.clear();
        this.controllerButtons.add(new ControllerButton(this, 0, 29, 9, 7, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 1, 32, 6, 13, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 2, 26, 6, 16, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 3, 29, 3, 10, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 9, 5, -2, 25, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 10, 26, -2, 32, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 11, -10, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 12, 41, 0, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(this, 14, 6, 9, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 16, 9, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 15, 3, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 13, 6, 3, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(this, 4, 14, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 6, 21, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(this, 5, 17, 8, 46, 0, 4, 4, 5));
        this.controllerButtons.add(new ControllerAxis(this, 7, 9, 12, 0, 0, 7, 7, 5));
        this.controllerButtons.add(new ControllerAxis(this, 8, 22, 12, 0, 0, 7, 7, 5));
        this.doneButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 154, this.field_230709_l_ - 32, 100, 20, (ITextComponent)new TranslationTextComponent("controllable.gui.save"), button -> {
            this.updateControllerMapping();
            this.field_230706_i_.func_147108_a(this.parentScreen);
        }));
        this.resetButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 50, this.field_230709_l_ - 32, 100, 20, (ITextComponent)new TranslationTextComponent("controllable.gui.reset"), button -> {
            this.entry.getReassignments().clear();
            this.entry.setSwitchThumbsticks(false);
            this.entry.setFlipLeftX(false);
            this.entry.setFlipLeftY(false);
            this.entry.setFlipRightX(false);
            this.entry.setFlipRightY(false);
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 54, this.field_230709_l_ - 32, 100, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), button -> this.field_230706_i_.func_147108_a(this.parentScreen)));
        int width = 190;
        int x = this.field_230708_k_ / 2 - width / 2;
        int y = this.field_230709_l_ / 2 - 50 - 35;
        this.thumbstickButton = (Button)this.func_230480_a_((Widget)new ImageButton(x + width / 2 - 10, y + 90, 20, TEXTURE, 92, 0, 16, 16, button -> this.field_230706_i_.func_147108_a((Screen)new ThumbstickSettingsScreen(this))));
    }

    public void func_231023_e_() {
        boolean changed = !this.entry.getReassignments().isEmpty();
        changed |= this.entry.isThumbsticksSwitched();
        changed |= this.entry.isFlipLeftX();
        changed |= this.entry.isFlipLeftY();
        changed |= this.entry.isFlipRightX();
        this.resetButton.field_230693_o_ = changed |= this.entry.isFlipRightY();
        this.validLayout = this.entry.getReassignments().values().stream().noneMatch(b -> b == -1);
        this.doneButton.func_238482_a_((ITextComponent)new TranslationTextComponent("controllable.gui.save").func_240699_a_(this.validLayout ? TextFormatting.WHITE : TextFormatting.RED));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ArrayList<Object> components;
        this.func_231165_f_(0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        int width = 190;
        int height = 120;
        int x = this.field_230708_k_ / 2 - width / 2;
        int y = this.field_230709_l_ / 2 - 50 - 35;
        ControllerLayoutScreen.func_238466_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)width, (int)height, (float)50.0f, (float)0.0f, (int)38, (int)24, (int)256, (int)256);
        this.controllerButtons.forEach(controllerButton -> controllerButton.draw(matrixStack, x, y, mouseX, mouseY, this.configureButton == controllerButton.button));
        ControllerLayoutScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        this.drawMultiLineCenteredString(matrixStack, this.field_230712_o_, (ITextComponent)new TranslationTextComponent("controllable.gui.layout.info").func_240699_a_(TextFormatting.GRAY), x + width / 2, y + 135, width + 190, -1);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.configureButton != -1) {
            RenderSystem.disableDepthTest();
            this.func_238468_a_(matrixStack, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
            ControllerLayoutScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("controllable.gui.layout.press_button"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2), (int)-1);
            RenderSystem.enableDepthTest();
            return;
        }
        ControllerButton button = this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null);
        if (button != null) {
            components = new ArrayList<Object>();
            components.add(new TranslationTextComponent("controllable.gui.layout.button", new Object[]{new TranslationTextComponent(Buttons.NAMES[button.getButton()]).func_240699_a_(TextFormatting.BLUE)}));
            if (button.isMissingMapping()) {
                components.add(new TranslationTextComponent("controllable.gui.layout.missing_mapping").func_240699_a_(TextFormatting.RED));
            } else {
                int remappedButton = button.getButton();
                if (!button.isMissingMapping()) {
                    Map<Integer, Integer> reassignments = this.entry.getReassignments();
                    for (Integer key : reassignments.keySet()) {
                        if (reassignments.get(key) != remappedButton) continue;
                        remappedButton = key;
                        break;
                    }
                }
                components.add(new TranslationTextComponent("controllable.gui.layout.mapped_to", new Object[]{new StringTextComponent(String.valueOf(remappedButton)).func_240699_a_(TextFormatting.BLUE)}));
            }
            components.add(new TranslationTextComponent("controllable.gui.layout.remap").func_240699_a_(TextFormatting.GRAY));
            this.func_243308_b(matrixStack, components, mouseX, mouseY);
        }
        if (!this.validLayout && this.doneButton.func_230449_g_()) {
            components = new ArrayList();
            components.add(new TranslationTextComponent("controllable.gui.layout.warning").func_240699_a_(TextFormatting.RED).func_241878_f());
            components.addAll(this.field_230712_o_.func_238425_b_((ITextProperties)new TranslationTextComponent("controllable.gui.layout.invalid_layout").func_240699_a_(TextFormatting.GRAY), 180));
            this.func_238654_b_(matrixStack, components, mouseX, mouseY - 50);
        }
        if (this.thumbstickButton.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("controllable.gui.layout.thumbsticks"), mouseX, mouseY);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        ControllerButton button;
        if (mouseButton == 0 && this.configureButton == -1 && (button = (ControllerButton)this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null)) != null) {
            this.configureButton = button.getButton();
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231046_a_(int key, int scanCode, int mods) {
        if (key == 256 && this.configureButton != -1) {
            this.configureButton = -1;
            return true;
        }
        return super.func_231046_a_(key, scanCode, mods);
    }

    public boolean onButtonInput(int button) {
        if (this.configureButton != -1) {
            Map<Integer, Integer> reassignments = this.entry.getReassignments();
            if (button != this.configureButton) {
                reassignments.putIfAbsent(this.configureButton, -1);
                for (Integer key : reassignments.keySet()) {
                    if (reassignments.get(key) != this.configureButton) continue;
                    reassignments.put(key, -1);
                }
                reassignments.put(button, this.configureButton);
            } else {
                reassignments.remove(button);
                for (Integer key : reassignments.keySet()) {
                    if (reassignments.get(key) != button) continue;
                    reassignments.put(key, -1);
                }
            }
            this.configureButton = -1;
            return true;
        }
        return false;
    }

    private void updateControllerMapping() {
        Controller controller = Controllable.getController();
        if (controller != null) {
            controller.setMapping(this.entry);
            this.entry.save();
        }
    }

    public void processButton(int index, ButtonStates newStates) {
        boolean state = newStates.getState(index);
        if (state && this.onButtonInput(index)) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if ((index = this.remap(index)) == -1) {
            return;
        }
        if (state) {
            if (!this.states.getState(index)) {
                this.states.setState(index, true);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187885_gS, (float)1.0f));
            }
        } else if (this.states.getState(index)) {
            this.states.setState(index, false);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187885_gS, (float)0.9f));
        }
    }

    public int remap(int button) {
        return this.entry.remap(button);
    }

    public boolean isButtonPressed(int button) {
        return this.states.getState(button);
    }

    public Map<Integer, Integer> getReassignments() {
        return this.entry.getReassignments();
    }

    public Mappings.Entry getEntry() {
        return this.entry;
    }

    private void drawMultiLineCenteredString(MatrixStack matrixStack, FontRenderer font, ITextComponent component, int x, int y, int width, int color) {
        for (IReorderingProcessor s : font.func_238425_b_((ITextProperties)component, width)) {
            font.func_238407_a_(matrixStack, s, (float)((double)x - (double)font.func_243245_a(s) / 2.0), (float)y, color);
            font.getClass();
            y += 9;
        }
    }

    public static class LayoutButtonStates
    extends ButtonStates {
        @Override
        public void setState(int index, boolean state) {
            super.setState(index, state);
        }
    }
}

