/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketOpenCurios;

public class ClientEventHandler {
    private static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    @SubscribeEvent
    public void onKeyInput(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (KeyRegistry.openCurios.func_151468_f() && mc.func_195544_aj()) {
            NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketOpenCurios());
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent evt) {
        ItemStack stack = evt.getItemStack();
        PlayerEntity player = evt.getPlayer();
        if (!stack.func_190926_b()) {
            Set<String> curioTags;
            ArrayList<String> slots;
            List tooltip = evt.getToolTip();
            CompoundNBT tag = stack.func_77978_p();
            int i = 0;
            if (tag != null && tag.func_150297_b("HideFlags", 99)) {
                i = tag.func_74762_e("HideFlags");
            }
            if (!(slots = new ArrayList<String>(curioTags = CuriosApi.getCuriosHelper().getCurioTags(stack.func_77973_b()))).isEmpty()) {
                ArrayList<IFormattableTextComponent> tagTooltips = new ArrayList<IFormattableTextComponent>();
                IFormattableTextComponent slotsTooltip = new TranslationTextComponent("curios.slot").func_240702_b_(": ").func_240699_a_(TextFormatting.GOLD);
                for (int j = 0; j < slots.size(); ++j) {
                    String key = "curios.identifier." + (String)slots.get(j);
                    TranslationTextComponent type = new TranslationTextComponent(key);
                    if (j < slots.size() - 1) {
                        type = type.func_240702_b_(", ");
                    }
                    type = type.func_240699_a_(TextFormatting.YELLOW);
                    slotsTooltip.func_230529_a_((ITextComponent)type);
                }
                tagTooltips.add(slotsTooltip);
                LazyOptional<ICurio> optionalCurio = CuriosApi.getCuriosHelper().getCurio(stack);
                optionalCurio.ifPresent(curio -> {
                    List<ITextComponent> curioTagsTooltip = curio.getTagsTooltip(tagTooltips);
                    if (!curioTagsTooltip.isEmpty()) {
                        tooltip.addAll(1, curio.getTagsTooltip(tagTooltips));
                    }
                });
                if (!optionalCurio.isPresent()) {
                    tooltip.addAll(1, tagTooltips);
                }
                for (String identifier : slots) {
                    Multimap<Attribute, AttributeModifier> multimap = CuriosApi.getCuriosHelper().getAttributeModifiers(new SlotContext(identifier, (LivingEntity)player), UUID.randomUUID(), stack);
                    boolean addAttributeTooltips = optionalCurio.map(curio -> curio.showAttributesTooltip(identifier)).orElse(true);
                    if (!addAttributeTooltips || multimap.isEmpty() || (i & 2) != 0) continue;
                    tooltip.add(StringTextComponent.field_240750_d_);
                    tooltip.add(new TranslationTextComponent("curios.modifiers." + identifier).func_240699_a_(TextFormatting.GOLD));
                    for (Map.Entry entry : multimap.entries()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        double amount = attributemodifier.func_111164_d();
                        boolean flag = false;
                        if (player == null) continue;
                        if (attributemodifier.func_111167_a() == ATTACK_DAMAGE_MODIFIER) {
                            ModifiableAttributeInstance att = player.func_110148_a(Attributes.field_233823_f_);
                            if (att != null) {
                                amount += att.func_111125_b();
                            }
                            amount += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)CreatureAttribute.field_223222_a_);
                            flag = true;
                        } else if (attributemodifier.func_111167_a() == ATTACK_SPEED_MODIFIER) {
                            ModifiableAttributeInstance att = player.func_110148_a(Attributes.field_233825_h_);
                            if (att != null) {
                                amount += att.func_111125_b();
                            }
                            flag = true;
                        }
                        double d1 = attributemodifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? amount : amount * 100.0;
                        if (flag) {
                            tooltip.add(new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("attribute.modifier.equals." + attributemodifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(((Attribute)entry.getKey()).func_233754_c_())})).func_240699_a_(TextFormatting.DARK_GREEN));
                            continue;
                        }
                        if (amount > 0.0) {
                            tooltip.add(new TranslationTextComponent("attribute.modifier.plus." + attributemodifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(((Attribute)entry.getKey()).func_233754_c_())}).func_240699_a_(TextFormatting.BLUE));
                            continue;
                        }
                        if (!(amount < 0.0)) continue;
                        tooltip.add(new TranslationTextComponent("attribute.modifier.take." + attributemodifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent(((Attribute)entry.getKey()).func_233754_c_())}).func_240699_a_(TextFormatting.RED));
                    }
                }
            }
        }
    }
}

