/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiousshulkerboxes;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curiousshulkerboxes.client.EventHandlerClient;
import top.theillusivec4.curiousshulkerboxes.client.KeyRegistry;
import top.theillusivec4.curiousshulkerboxes.common.capability.CurioShulkerBox;
import top.theillusivec4.curiousshulkerboxes.common.integration.enderitemod.EnderiteModIntegration;
import top.theillusivec4.curiousshulkerboxes.common.integration.ironshulkerbox.IronShulkerBoxIntegration;
import top.theillusivec4.curiousshulkerboxes.common.integration.netherite_plus.NetheritePlusIntegration;
import top.theillusivec4.curiousshulkerboxes.common.network.NetworkHandler;

@Mod(value="curiousshulkerboxes")
public class CuriousShulkerBoxes {
    public static final String MODID = "curiousshulkerboxes";
    public static boolean isIronShulkerBoxesLoaded = false;
    public static boolean isNetheritePlusLoaded = false;
    public static boolean isEnderiteLoaded = false;

    public CuriousShulkerBoxes() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::enqueue);
        ModList modList = ModList.get();
        isIronShulkerBoxesLoaded = modList.isLoaded("ironshulkerbox");
        isNetheritePlusLoaded = modList.isLoaded("netherite_plus");
        isEnderiteLoaded = modList.isLoaded("enderitemod");
    }

    public static boolean isShulkerBox(Item item) {
        Block block = Block.func_149634_a((Item)item);
        if (isIronShulkerBoxesLoaded && IronShulkerBoxIntegration.isIronShulkerBox(block)) {
            return true;
        }
        if (isNetheritePlusLoaded && NetheritePlusIntegration.isNetheriteShulkerBox(block)) {
            return true;
        }
        if (isEnderiteLoaded && EnderiteModIntegration.isEnderiteShulkerBox(block)) {
            return true;
        }
        return block instanceof ShulkerBoxBlock;
    }

    public static Optional<ImmutableTriple<String, Integer, ItemStack>> getCurioShulkerBox(LivingEntity livingEntity) {
        Predicate<ItemStack> shulkerBox = stack -> CuriousShulkerBoxes.isShulkerBox(stack.func_77973_b());
        return CuriosApi.getCuriosHelper().findEquippedCurio(shulkerBox, livingEntity);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkHandler.register();
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        KeyRegistry.register();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
    }

    private void enqueue(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        if (CuriousShulkerBoxes.isShulkerBox(stack.func_77973_b())) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            Object curioShulkerBox = isIronShulkerBoxesLoaded && IronShulkerBoxIntegration.isIronShulkerBox(block) ? IronShulkerBoxIntegration.getCurio(stack) : (isNetheritePlusLoaded && NetheritePlusIntegration.isNetheriteShulkerBox(block) ? NetheritePlusIntegration.getCurio(stack) : (isEnderiteLoaded && EnderiteModIntegration.isEnderiteShulkerBox(block) ? EnderiteModIntegration.getCurio(stack) : new CurioShulkerBox(stack)));
            stack.func_190925_c("BlockEntityTag");
            evt.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider((ICurio)curioShulkerBox){
                LazyOptional<ICurio> curio = LazyOptional.of(() -> this.val$curioShulkerBox);
                final /* synthetic */ ICurio val$curioShulkerBox;
                {
                    this.val$curioShulkerBox = iCurio;
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, this.curio);
                }
            });
        }
    }
}

