/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiousshulkerboxes.common.network.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curiousshulkerboxes.CuriousShulkerBoxes;
import top.theillusivec4.curiousshulkerboxes.common.capability.CurioShulkerBox;

public class SPacketSyncAnimation {
    private final int entityId;
    private final String identifier;
    private final int index;
    private final boolean isClosing;

    public SPacketSyncAnimation(int entityId, String identifier, int index, boolean isClosing) {
        this.entityId = entityId;
        this.identifier = identifier;
        this.index = index;
        this.isClosing = isClosing;
    }

    public static void encode(SPacketSyncAnimation msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.func_180714_a(msg.identifier);
        buf.writeInt(msg.index);
        buf.writeBoolean(msg.isClosing);
    }

    public static SPacketSyncAnimation decode(PacketBuffer buf) {
        return new SPacketSyncAnimation(buf.readInt(), buf.func_150789_c(25), buf.readInt(), buf.readBoolean());
    }

    public static void handle(SPacketSyncAnimation msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return;
            }
            Entity entity = world.func_73045_a(msg.entityId);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(handler -> handler.getStacksHandler(msg.identifier).ifPresent(stacksHandler -> {
                ItemStack stack;
                if (msg.index < stacksHandler.getSlots() && CuriousShulkerBoxes.isShulkerBox((stack = stacksHandler.getStacks().getStackInSlot(msg.index)).func_77973_b())) {
                    CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> {
                        if (curio instanceof CurioShulkerBox) {
                            if (msg.isClosing) {
                                ((CurioShulkerBox)curio).setAnimationStatus(ShulkerBoxTileEntity.AnimationStatus.CLOSING);
                            } else {
                                ((CurioShulkerBox)curio).setAnimationStatus(ShulkerBoxTileEntity.AnimationStatus.OPENING);
                            }
                        }
                    });
                }
            }));
        });
        ctx.get().setPacketHandled(true);
    }
}

