/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.doubledoors.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHandler {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Boolean> enableRecursiveOpening;
        public final ForgeConfigSpec.ConfigValue<Integer> recursiveOpeningMaxBlocksDistance;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableDoors;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableFenceGates;
        public final ForgeConfigSpec.ConfigValue<Boolean> enableTrapdoors;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.enableRecursiveOpening = builder.comment("Whether the recursive opening feature should be enabled. This allows you to for example build a giant door with trapdoors which will all open at the same time, as long as they are connected. The 'recursiveOpeningMaxBlocksDistance' config option determines how far the function should search.").define("enableRecursiveOpening", true);
            this.recursiveOpeningMaxBlocksDistance = builder.comment("How many blocks the recursive function should search when 'enableRecursiveOpening' is enabled.").defineInRange("recursiveOpeningMaxBlocksDistance", 10, 1, 64);
            this.enableDoors = builder.comment("When enables, the mod works with double doors.").define("enableDoors", true);
            this.enableFenceGates = builder.comment("When enables, the mod works with double fence gates.").define("enableFenceGates", true);
            this.enableTrapdoors = builder.comment("When enables, the mod works with double trapdoors.").define("enableTrapdoors", true);
            builder.pop();
        }
    }
}

