/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.doubledoors.events;

import com.natamus.collective.functions.WorldFunctions;
import com.natamus.doubledoors.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.StoneButtonBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DoorEvent {
    private static List<BlockPos> prevpoweredpos = new ArrayList<BlockPos>();
    private static HashMap<BlockPos, Integer> prevbuttonpos = new HashMap();

    @SubscribeEvent
    public void onNeighbourNotice(BlockEvent.NeighborNotifyEvent e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        BooleanProperty proppowered = BlockStateProperties.field_208194_u;
        BlockPos pos = e.getPos().func_185334_h();
        BlockState state = e.getState();
        Block block = state.func_177230_c();
        if (!(block instanceof PressurePlateBlock)) {
            if (!(block instanceof StoneButtonBlock) && !(block instanceof WoodButtonBlock)) {
                return;
            }
            if (!prevbuttonpos.containsKey(pos)) {
                prevbuttonpos.put(pos, 1);
                return;
            }
            prevbuttonpos.remove(pos);
            if (!((Boolean)state.func_177229_b((Property)proppowered)).booleanValue()) {
                if (!prevpoweredpos.contains(pos)) {
                    return;
                }
                prevpoweredpos.remove(pos);
            }
        } else if (!((Boolean)state.func_177229_b((Property)proppowered)).booleanValue() && !prevpoweredpos.contains(pos)) {
            return;
        }
        boolean playsound = true;
        boolean stateprop = (Boolean)state.func_177229_b((Property)proppowered);
        Iterator blocksaround = BlockPos.func_218287_a((int)(pos.func_177958_n() - 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)(pos.func_177956_o() + 1), (int)(pos.func_177952_p() + 1)).iterator();
        BlockPos doorpos = null;
        while (blocksaround.hasNext()) {
            BlockPos npos = ((BlockPos)blocksaround.next()).func_185334_h();
            BlockState ostate = world.func_180495_p(npos);
            if (!Util.isDoorBlock(ostate)) continue;
            doorpos = npos;
            break;
        }
        if (doorpos != null && Util.processDoor(world, doorpos, world.func_180495_p(doorpos), stateprop, playsound) && stateprop) {
            prevpoweredpos.add(pos);
        }
    }

    @SubscribeEvent
    public void onDoorClick(PlayerInteractEvent.RightClickBlock e) {
        World world = e.getWorld();
        if (world.field_72995_K && e.getHand().equals((Object)Hand.MAIN_HAND)) {
            return;
        }
        PlayerEntity player = e.getPlayer();
        if (player.func_225608_bj_()) {
            return;
        }
        BlockPos cpos = e.getPos();
        BlockState clickstate = world.func_180495_p(cpos);
        if (!Util.isDoorBlock(clickstate)) {
            return;
        }
        if (clickstate.func_185904_a().equals(Material.field_151573_f)) {
            return;
        }
        if (Util.processDoor(world, cpos, clickstate, null, true)) {
            e.setUseBlock(Event.Result.DENY);
            e.setCanceled(true);
        }
    }
}

