/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.doubledoors.util;

import com.natamus.collective.functions.BlockPosFunctions;
import com.natamus.doubledoors.config.ConfigHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.StoneButtonBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Util {
    public static boolean isDoorBlock(BlockState blockstate) {
        Block block = blockstate.func_177230_c();
        return block instanceof DoorBlock || block instanceof TrapDoorBlock || block instanceof FenceGateBlock;
    }

    public static boolean isPressureBlock(BlockState blockstate) {
        Block block = blockstate.func_177230_c();
        return (block instanceof PressurePlateBlock || block instanceof WoodButtonBlock || block instanceof StoneButtonBlock) && (Boolean)blockstate.func_177229_b((Property)BlockStateProperties.field_208194_u) != false;
    }

    public static boolean processDoor(World world, BlockPos pos, BlockState state, Boolean isopen, boolean playsound) {
        List<BlockPos> postoopen;
        Block block = state.func_177230_c();
        if (block instanceof DoorBlock && ((DoubleBlockHalf)state.func_177229_b((Property)DoorBlock.field_176523_O)).equals((Object)DoubleBlockHalf.UPPER)) {
            pos = pos.func_177977_b().func_185334_h();
            state = world.func_180495_p(pos);
        }
        if (isopen == null) {
            isopen = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208193_t) == false;
        }
        int yoffset = 0;
        if (!(block instanceof DoorBlock)) {
            yoffset = 1;
        }
        if ((postoopen = Util.recursivelyOpenDoors(new ArrayList<BlockPos>(Arrays.asList(pos.func_185334_h())), new ArrayList<BlockPos>(), world, pos, pos, block, yoffset)).size() <= 1) {
            return false;
        }
        for (BlockPos toopen : postoopen) {
            BlockState ostate = world.func_180495_p(toopen);
            Block oblock = ostate.func_177230_c();
            if (block instanceof DoorBlock) {
                if (!((Boolean)ConfigHandler.GENERAL.enableDoors.get()).booleanValue()) continue;
                DoorBlock door = (DoorBlock)oblock;
                if (playsound) {
                    door.func_242663_a(world, ostate, toopen, isopen.booleanValue());
                    playsound = false;
                    continue;
                }
                world.func_180501_a(toopen, (BlockState)ostate.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)isopen), 10);
                continue;
            }
            if (block instanceof TrapDoorBlock) {
                if (!((Boolean)ConfigHandler.GENERAL.enableTrapdoors.get()).booleanValue()) continue;
                if (playsound) {
                    if (isopen.booleanValue()) {
                        int i = ostate.func_185904_a() == Material.field_151573_f ? 1037 : 1007;
                        world.func_217378_a(null, i, pos, 0);
                    } else {
                        int j = ostate.func_185904_a() == Material.field_151573_f ? 1036 : 1013;
                        world.func_217378_a(null, j, pos, 0);
                    }
                    playsound = false;
                }
                world.func_180501_a(toopen, (BlockState)ostate.func_206870_a((Property)BlockStateProperties.field_208193_t, (Comparable)isopen), 10);
                continue;
            }
            if (!(block instanceof FenceGateBlock) || !((Boolean)ConfigHandler.GENERAL.enableFenceGates.get()).booleanValue()) continue;
            world.func_180501_a(toopen, (BlockState)ostate.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)isopen), 10);
        }
        return postoopen.size() > 1;
    }

    private static List<BlockPos> recursivelyOpenDoors(List<BlockPos> postoopen, List<BlockPos> ignoreoopen, World world, BlockPos originalpos, BlockPos pos, Block block, int yoffset) {
        Iterator blocksaround = BlockPos.func_218287_a((int)(pos.func_177958_n() - 1), (int)(pos.func_177956_o() - yoffset), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)(pos.func_177956_o() + yoffset), (int)(pos.func_177952_p() + 1)).iterator();
        while (blocksaround.hasNext()) {
            BlockPos bpa = (BlockPos)blocksaround.next();
            if (postoopen.contains(bpa) || !BlockPosFunctions.withinDistance((BlockPos)originalpos, (BlockPos)bpa, (int)((Integer)ConfigHandler.GENERAL.recursiveOpeningMaxBlocksDistance.get())).booleanValue()) continue;
            BlockState ostate = world.func_180495_p(bpa);
            Block oblock = ostate.func_177230_c();
            if (Util.isDoorBlock(ostate) && oblock.getRegistryName().equals((Object)block.getRegistryName())) {
                postoopen.add(bpa.func_185334_h());
                if (!((Boolean)ConfigHandler.GENERAL.enableRecursiveOpening.get()).booleanValue()) continue;
                Util.recursivelyOpenDoors(postoopen, ignoreoopen, world, originalpos, bpa, block, yoffset);
                continue;
            }
            ignoreoopen.add(bpa.func_185334_h());
        }
        return postoopen;
    }
}

