/*
 * Decompiled with CFR 0.152.
 */
package net.environmentz.util;

import com.mojang.blaze3d.systems.RenderSystem;
import net.environmentz.effect.ColdEffect;
import net.environmentz.effect.OverheatingEffect;
import net.environmentz.init.ConfigInit;
import net.environmentz.init.EffectInit;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class TemperatureHudRendering {
    private static final class_2960 FREEZING_ICON = new class_2960("environmentz:textures/gui/coldness.png");
    private static final class_2960 OVERHEATING_ICON = new class_2960("environmentz:textures/gui/overheating.png");
    public static float smoothFreezingIconRendering;
    public static float smoothThirstRendering;
    public static boolean isInColdBiome;
    public static boolean isInHotBiome;

    public static void hotEnvRendering(class_1657 playerEntity, int wetTimer) {
        isInHotBiome = true;
        if (OverheatingEffect.wearsArmor((class_1309)playerEntity) && playerEntity.field_6002.method_8311(playerEntity.method_24515()) && ((int)playerEntity.field_6002.method_8532() > 23000 || (int)playerEntity.field_6002.method_8532() < 12000)) {
            float wetBonus = 0.0f;
            if (playerEntity.method_6059(EffectInit.WET) && wetTimer == ConfigInit.CONFIG.wet_bonus_malus) {
                wetBonus = 0.5f;
            }
            if (smoothThirstRendering < 1.0f) {
                smoothThirstRendering += 1.0f / ((float)ConfigInit.CONFIG.overheating_tick_interval * (1.0f + wetBonus));
            }
            if (smoothThirstRendering > 1.0f) {
                smoothThirstRendering = 1.0f;
            }
        } else if (smoothThirstRendering > 0.0f) {
            smoothThirstRendering -= 1.0f / (float)ConfigInit.CONFIG.cooling_down_interval;
        }
    }

    public static void coldEnvRendering(class_1657 playerEntity, int wetTimer) {
        isInColdBiome = true;
        int warmClothingModifier = ColdEffect.warmClothingModifier((class_1309)playerEntity);
        if (!playerEntity.method_6059(EffectInit.WARMING) && warmClothingModifier != ConfigInit.CONFIG.warm_armor_tick_modifier * 4 && !ColdEffect.isWarmBlockNearBy((class_1309)playerEntity)) {
            float wetMalus = 1.0f;
            if (playerEntity.method_6059(EffectInit.WET) && wetTimer == ConfigInit.CONFIG.wet_bonus_malus) {
                wetMalus = 0.5f;
            }
            if (smoothFreezingIconRendering < 1.0f) {
                smoothFreezingIconRendering += 1.0f / ((float)(ConfigInit.CONFIG.cold_tick_interval + warmClothingModifier) * wetMalus);
            }
            if (smoothFreezingIconRendering > 1.0f) {
                smoothFreezingIconRendering = 1.0f;
            }
        } else if (smoothFreezingIconRendering > 0.0f) {
            smoothFreezingIconRendering -= 1.0f / (float)ConfigInit.CONFIG.heating_up_interval;
        }
    }

    public static void renderTemperatureAspect(class_4587 matrixStack, class_1657 playerEntity, class_310 client) {
        if (!ConfigInit.CONFIG.excluded_cold_names.contains(playerEntity.method_5477().method_10851()) && isInColdBiome && smoothFreezingIconRendering > 0.0f) {
            TemperatureHudRendering.renderIconBackgroundOverlay(matrixStack, FREEZING_ICON, client);
            if (smoothFreezingIconRendering > 0.0f) {
                TemperatureHudRendering.renderIconOverlay(matrixStack, smoothFreezingIconRendering, FREEZING_ICON, client);
            }
        } else if (!ConfigInit.CONFIG.excluded_heat_names.contains(playerEntity.method_5477().method_10851()) && isInHotBiome && smoothThirstRendering > 0.0f) {
            TemperatureHudRendering.renderIconBackgroundOverlay(matrixStack, OVERHEATING_ICON, client);
            if (smoothThirstRendering > 0.0f) {
                TemperatureHudRendering.renderIconOverlay(matrixStack, smoothThirstRendering, OVERHEATING_ICON, client);
            }
        }
    }

    public static void renderIconOverlay(class_4587 matrixStack, float smooth, class_2960 identifier, class_310 client) {
        int scaledWidth = client.method_22683().method_4486();
        int scaledHeight = client.method_22683().method_4502();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        client.method_1531().method_22813(identifier);
        class_332.method_25290((class_4587)matrixStack, (int)(scaledWidth / 2 - ConfigInit.CONFIG.icon_x), (int)(scaledHeight - ConfigInit.CONFIG.icon_y + (13 - TemperatureHudRendering.iconTexture(smooth))), (float)13.0f, (float)(13.0f - (float)(TemperatureHudRendering.iconTexture(smooth) - 13)), (int)13, (int)TemperatureHudRendering.iconTexture(smooth), (int)26, (int)13);
    }

    public static void renderIconBackgroundOverlay(class_4587 matrixStack, class_2960 identifier, class_310 client) {
        int scaledWidth = client.method_22683().method_4486();
        int scaledHeight = client.method_22683().method_4502();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        client.method_1531().method_22813(identifier);
        class_332.method_25290((class_4587)matrixStack, (int)(scaledWidth / 2 - ConfigInit.CONFIG.icon_x), (int)(scaledHeight - ConfigInit.CONFIG.icon_y), (float)0.0f, (float)0.0f, (int)13, (int)13, (int)26, (int)13);
    }

    private static int iconTexture(float smooth) {
        if (smooth >= 0.85f) {
            return 13;
        }
        if (smooth > 0.68f) {
            return 10;
        }
        if (smooth > 0.51f) {
            return 8;
        }
        if (smooth > 0.34f) {
            return 5;
        }
        if (smooth > 0.17f) {
            return 3;
        }
        return 0;
    }
}

