/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.haema.mixin;

import com.williambl.haema.Vampirable;
import com.williambl.haema.VampireBloodManager;
import com.williambl.haema.abilities.VampireAbility;
import com.williambl.haema.api.VampireBurningEvents;
import com.williambl.haema.damagesource.DamageSourceExtensionsKt;
import com.williambl.haema.effect.SunlightSicknessEffect;
import com.williambl.haema.util.HaemaGameRulesKt;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements Vampirable {
    @Shadow
    protected class_1702 field_7493;
    @Shadow
    @Final
    public class_1656 field_7503;
    protected VampireBloodManager bloodManager = null;
    protected class_2487 nbt;

    @Shadow
    public abstract void method_6073(float var1);

    @Shadow
    public abstract float method_6067();

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"readCustomDataFromTag"}, at={@At(value="RETURN")})
    void addVampireHungerManager(class_2487 tag, CallbackInfo ci) {
        if (tag.method_10545("foodLevel")) {
            this.nbt = tag;
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;tick()V")})
    void vampireTick(CallbackInfo ci) {
        if (!Float.isFinite(this.method_6032()) || !Float.isFinite(this.method_6067()) || this.method_6032() < 0.0f || this.method_6067() < 0.0f) {
            this.method_6073(0.0f);
            this.method_6033(0.0f);
        }
        if (this.isVampire() && !this.method_29504()) {
            this.checkBloodManager();
            if (!this.field_6002.field_9236 && ((VampireBurningEvents.Trigger)VampireBurningEvents.INSTANCE.getTRIGGER().invoker()).willVampireBurn((class_1657)this, this.field_6002).get() && ((VampireBurningEvents.Veto)VampireBurningEvents.INSTANCE.getVETO().invoker()).willVampireBurn((class_1657)this, this.field_6002).get()) {
                this.method_6092(new class_1293(SunlightSicknessEffect.Companion.getInstance(), 5, 0));
            }
        }
    }

    @ModifyVariable(method={"applyDamage"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/player/PlayerEntity;applyEnchantmentsToDamage(Lnet/minecraft/entity/damage/DamageSource;F)F"), argsOnly=true, require=1, index=2)
    float tweakDamageIfVampire(float amount, class_1282 source) {
        float result2 = this.isVampire() && DamageSourceExtensionsKt.isEffectiveAgainstVampires(source, this.field_6002) ? amount * 1.25f : amount;
        return Float.isFinite(result2) ? result2 : amount;
    }

    @Redirect(method={"isInvulnerableTo"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Lnet/minecraft/world/GameRules$Key;)Z", ordinal=1))
    boolean makeVampiresImmuneToFalling(class_1928 gameRules, class_1928.class_4313<class_1928.class_4310> rule) {
        return gameRules.method_8355(rule) && (!this.isVampire() || this.getAbilityLevel(VampireAbility.Companion.getDASH()) < 3);
    }

    @Redirect(method={"isInvulnerableTo"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Lnet/minecraft/world/GameRules$Key;)Z", ordinal=0))
    boolean makeVampiresImmuneToDrowning(class_1928 gameRules, class_1928.class_4313<class_1928.class_4310> rule) {
        return gameRules.method_8355(rule) && (!this.isVampire() || gameRules.method_8355(HaemaGameRulesKt.getVampiresDrown()));
    }

    public boolean method_29504() {
        if (this.isVampire() && this.getAbilityLevel(VampireAbility.Companion.getIMMORTALITY()) > 0) {
            return super.method_29504() && this.isKilled();
        }
        return super.method_29504();
    }

    public boolean method_5805() {
        return this.isVampire() ? !this.method_29504() : super.method_5805();
    }

    @Override
    public void checkBloodManager() {
        if (this.bloodManager == null) {
            this.field_7493 = new VampireBloodManager();
            this.bloodManager = (VampireBloodManager)this.field_7493;
            if (this.nbt != null) {
                this.field_7493.method_7584(this.nbt);
                this.nbt = null;
            }
            this.bloodManager.setOwner((class_1657)this);
        }
    }

    @Override
    public void removeBloodManager() {
        this.field_7493 = new class_1702();
        this.bloodManager = null;
    }
}

