/*
 * Decompiled with CFR 0.152.
 */
package me.sizableshrimp.mojangdark.transform;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MojangDarkBootstrap {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern DARK_PATTERN = Pattern.compile("darkMojangStudiosBackground:(true|false)");
    private static Path gameDir;
    private static boolean initialized;
    private static boolean isDark;

    public static Path getGameDir() {
        if (gameDir == null) {
            try {
                Class<?> self = Class.forName("me.sizableshrimp.mojangdark.transform.MojangDarkBootstrap", true, ClassLoader.getSystemClassLoader());
                gameDir = (Path)self.getMethod("getGameDir", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Error loading self!", (Throwable)e);
                gameDir = null;
            }
        }
        return gameDir;
    }

    public static void setGameDir(Path gameDir) {
        MojangDarkBootstrap.gameDir = gameDir;
    }

    public static boolean isDark() {
        if (initialized) {
            return isDark;
        }
        initialized = true;
        try {
            if (MojangDarkBootstrap.getGameDir() == null) {
                LOGGER.warn("No game directory was set. This should not be possible!");
                isDark = true;
                return true;
            }
            Path optsPath = MojangDarkBootstrap.getGameDir().resolve("options.txt");
            if (!Files.exists(MojangDarkBootstrap.getGameDir(), new LinkOption[0]) || !Files.exists(optsPath, new LinkOption[0])) {
                isDark = true;
                return true;
            }
            String joined = String.join((CharSequence)"\n", Files.readAllLines(optsPath));
            Matcher matcher = DARK_PATTERN.matcher(joined);
            if (!matcher.find()) {
                isDark = true;
                return true;
            }
            isDark = "true".equals(matcher.group(1));
        }
        catch (IOException e) {
            LOGGER.error("Error when loading options", (Throwable)e);
            isDark = true;
        }
        return isDark;
    }

    public static void setDark(boolean isDark) {
        MojangDarkBootstrap.isDark = isDark;
    }

    static {
        initialized = false;
    }
}

