/*
 * Decompiled with CFR 0.152.
 */
package me.sizableshrimp.mojangdark.transform;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import me.sizableshrimp.mojangdark.transform.MojangDarkBootstrap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class MojangDarkLaunchPlugin {
    public static final int LOGO_BACKGROUND_COLOR = MojangDarkLaunchPlugin.packColor(255, 239, 50, 61);
    public static final int LOGO_BACKGROUND_COLOR_DARK = MojangDarkLaunchPlugin.packColor(255, 0, 0, 0);
    public static final IntSupplier BRAND_BACKGROUND_SUPPLIER = () -> MojangDarkBootstrap.isDark() ? LOGO_BACKGROUND_COLOR_DARK : LOGO_BACKGROUND_COLOR;
    private static final Map<String, float[]> LIGHT_TO_DARK = ImmutableMap.of((Object)"MC", (Object)new float[]{1.0f, 1.0f, 1.0f}, (Object)"ML", (Object)new float[]{0.0f, 0.5f, 1.0f}, (Object)"LOC", (Object)new float[]{0.0f, 0.5f, 0.0f}, (Object)"MOD", (Object)new float[]{1.0f, 0.0f, 0.0f});
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<String, NodeConsumer> CLASSES = ImmutableMap.builder().put((Object)"net/minecraftforge/fml/loading/progress/ClientVisualization.class", classNode -> {
        MethodNode methodNode = MojangDarkLaunchPlugin.findMethodNode(classNode, "renderBackground", "()V");
        MethodInsnNode instruction = MojangDarkLaunchPlugin.findInstructionNode(methodNode, 184, insn -> "org/lwjgl/opengl/GL11".equals(insn.owner) && "glColor4f".equals(insn.name) && "(FFFF)V".equals(insn.desc));
        methodNode.instructions.insertBefore((AbstractInsnNode)instruction, (AbstractInsnNode)MojangDarkLaunchPlugin.getInvokeStaticInsn("drawBackgroundColor", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE));
        methodNode.instructions.remove((AbstractInsnNode)instruction);
        return true;
    }).put((Object)"net/minecraftforge/fml/loading/progress/StartupMessageManager$MessageType.class", classNode -> {
        MethodNode methodNode = MojangDarkLaunchPlugin.findMethodNode(classNode, "colour", "()[F");
        FieldInsnNode instruction = MojangDarkLaunchPlugin.findInstructionNode(methodNode, 180, insn -> "colour".equals(insn.name));
        methodNode.instructions.insertBefore((AbstractInsnNode)instruction, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/fml/loading/progress/StartupMessageManager$MessageType", "name", "()Ljava/lang/String;"));
        methodNode.instructions.insertBefore((AbstractInsnNode)instruction, (AbstractInsnNode)new VarInsnNode(25, 0));
        methodNode.instructions.insert((AbstractInsnNode)instruction, (AbstractInsnNode)MojangDarkLaunchPlugin.getInvokeStaticInsn("convertColor", String.class, float[].class));
        return true;
    }).build();

    public static byte[] transform(String name, byte[] input) {
        ClassNode classNode = new ClassNode();
        new ClassReader(input).accept((ClassVisitor)classNode, 8);
        boolean modified = false;
        try {
            modified = CLASSES.get(name).accept(classNode);
        }
        catch (Exception e) {
            LOGGER.error("Error when transforming", (Throwable)e);
        }
        if (modified) {
            ClassWriter cw = new ClassWriter(3);
            classNode.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return input;
    }

    private static MethodInsnNode getInvokeStaticInsn(String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        String internalName = Type.getType(MojangDarkLaunchPlugin.class).getInternalName();
        Method method = MojangDarkLaunchPlugin.class.getMethod(methodName, parameterTypes);
        Type methodType = Type.getType((Method)method);
        return new MethodInsnNode(184, internalName, method.getName(), methodType.getDescriptor());
    }

    private static MethodNode findMethodNode(ClassNode classNode, String methodName, String descriptor) throws Exception {
        for (MethodNode methodNode : classNode.methods) {
            if (!Objects.equals(methodNode.name, methodName) || !Objects.equals(methodNode.desc, descriptor)) continue;
            return methodNode;
        }
        throw new Exception(String.format("No method node found with name %s and descriptor %s", methodName, descriptor));
    }

    private static <T extends AbstractInsnNode> T findInstructionNode(MethodNode methodNode, int opcode, Predicate<T> applier) throws Exception {
        for (AbstractInsnNode instruction : methodNode.instructions) {
            AbstractInsnNode castedInsn;
            boolean success;
            if (instruction.getOpcode() != opcode || !(success = applier.test(castedInsn = instruction))) continue;
            return (T)castedInsn;
        }
        throw new Exception(String.format("No instruction node found in method %s and opcode %d", methodNode.name, opcode));
    }

    public static float[] convertColor(String name, float[] color) {
        return MojangDarkBootstrap.isDark() ? LIGHT_TO_DARK.get(name) : color;
    }

    public static void drawBackgroundColor(float red, float green, float blue, float alpha) {
        int packedColor = BRAND_BACKGROUND_SUPPLIER.getAsInt();
        red = (float)MojangDarkLaunchPlugin.red(packedColor) / 255.0f;
        green = (float)MojangDarkLaunchPlugin.green(packedColor) / 255.0f;
        blue = (float)MojangDarkLaunchPlugin.blue(packedColor) / 255.0f;
        alpha = (float)MojangDarkLaunchPlugin.alpha(packedColor) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static int packColor(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    private static int alpha(int packedColor) {
        return packedColor >>> 24;
    }

    private static int red(int packedColor) {
        return packedColor >> 16 & 0xFF;
    }

    private static int green(int packedColor) {
        return packedColor >> 8 & 0xFF;
    }

    private static int blue(int packedColor) {
        return packedColor & 0xFF;
    }

    private static interface NodeConsumer {
        public boolean accept(ClassNode var1) throws Exception;
    }
}

