/*
 * Decompiled with CFR 0.152.
 */
package me.sizableshrimp.mojangdark.transform;

import com.google.common.collect.ImmutableList;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileLocator;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MojangDarkLocator
extends AbstractJarFileLocator {
    private static final Logger LOGGER = LogManager.getLogger();

    public List<IModFile> scanMods() {
        CodeSource codeSource = MojangDarkLocator.class.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return ImmutableList.of();
        }
        try {
            Path path = Paths.get(codeSource.getLocation().toURI());
            if (!Files.isDirectory(path, new LinkOption[0]) && StringUtils.toLowerCase((String)path.getFileName().toString()).endsWith(".jar")) {
                LOGGER.debug(LogMarkers.SCAN, "Found MojangDark mod jar");
                ModFile modFile = ModFile.newFMLInstance((Path)path, (IModLocator)this);
                this.modJars.put(modFile, this.createFileSystem((IModFile)modFile));
                return ImmutableList.of((Object)modFile);
            }
        }
        catch (URISyntaxException e) {
            LOGGER.error("Error when scanning for MojangDark mod jar", (Throwable)e);
        }
        return ImmutableList.of();
    }

    public String name() {
        return "mojangdark mod jar";
    }

    public void initArguments(Map<String, ?> arguments) {
    }
}

