/*
 * Decompiled with CFR 0.152.
 */
package me.sizableshrimp.mojangdark.transform;

import com.google.common.collect.ImmutableList;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import me.sizableshrimp.mojangdark.transform.ClassLoaderUtils;
import me.sizableshrimp.mojangdark.transform.FakeJarFile;
import me.sizableshrimp.mojangdark.transform.MojangDarkBootstrap;
import net.minecraftforge.fml.loading.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MojangDarkTransformationService
implements ITransformationService {
    private static final Logger LOGGER = LogManager.getLogger();
    private static URL zipUrl;
    private static ZipFile zipFile;

    @Nonnull
    public String name() {
        return "mojangdark";
    }

    public void initialize(IEnvironment environment) {
    }

    public void beginScanning(IEnvironment environment) {
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) throws IncompatibleEnvironmentException {
        LOGGER.info("Loading MojangDark transformation service");
        try {
            CodeSource codeSource = MojangDarkTransformationService.class.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                return;
            }
            zipUrl = codeSource.getLocation();
            File file = new File(zipUrl.toURI());
            if (!file.isDirectory() && StringUtils.toLowerCase((String)file.getName()).endsWith(".jar")) {
                zipFile = new ZipFile(file);
                ClassLoaderUtils.appendToClassPath(ClassLoader.getSystemClassLoader(), zipUrl);
            }
            MojangDarkBootstrap.setGameDir(env.getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).orElseGet(() -> Paths.get(".", new String[0])));
            FakeJarFile.replaceLoaders();
        }
        catch (Throwable e) {
            LOGGER.error("Error loading transformation service", e);
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public List<ITransformer> transformers() {
        return ImmutableList.of();
    }
}

