/*
 * Decompiled with CFR 0.152.
 */
package io.github.joaoh1.okzoomer.client.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.Setting;

public class OkZoomerConfigPojo {
    @Setting.Group
    public static FeaturesGroup features = new FeaturesGroup();
    @Setting.Group
    public static ValuesGroup values = new ValuesGroup();
    @Setting.Group
    public static TweaksGroup tweaks = new TweaksGroup();

    public static class FeaturesGroup {
        @Setting(comment="Defines the cinematic camera while zooming.\n\"OFF\" disables the cinematic camera.\n\"VANILLA\" uses Vanilla's cinematic camera.\n\"MULTIPLIED\" is a multiplied variant of \"VANILLA\".")
        public CinematicCameraOptions cinematicCamera = CinematicCameraOptions.OFF;
        @Setting(comment="Reduces the mouse sensitivity when zooming.")
        public boolean reduceSensitivity = true;
        @Setting(comment="Adds transitions between zooms.\n\"OFF\" disables transitions.\n\"SMOOTH\" replicates Vanilla's dynamic FOV.\n\"LINEAR\" removes the smoothiness.")
        public ZoomTransitionOptions zoomTransition = ZoomTransitionOptions.SMOOTH;
        @Setting(comment="The behavior of the zoom key.\n\"HOLD\" needs the zoom key to be hold.\n\"TOGGLE\" has the zoom key toggle the zoom.\n\"PERSISTENT\" makes the zoom permanent.")
        public ZoomModes zoomMode = ZoomModes.HOLD;
        @Setting(comment="Allows to increase or decrease zoom by scrolling.")
        public boolean zoomScrolling = true;
        @Setting(comment="Adds zoom manipulation keys along with the zoom key.")
        public boolean extraKeybinds = true;
        @Setting(comment="Adds an overlay in the screen during zoom. The overlay texture can be found at: assets/okzoomer/textures/misc/zoom_overlay.png")
        public boolean zoomOverlay = false;

        public static enum CinematicCameraOptions {
            OFF,
            VANILLA,
            MULTIPLIED;

        }

        public static enum ZoomTransitionOptions {
            OFF,
            SMOOTH,
            LINEAR;

        }

        public static enum ZoomModes {
            HOLD,
            TOGGLE,
            PERSISTENT;

        }
    }

    public static class ValuesGroup {
        @Setting(comment="The divisor applied to the FOV when zooming.")
        public @Setting.Constrain.Range(min=2.2250738585072014E-308) double zoomDivisor = 4.0;
        @Setting(comment="The minimum value that you can scroll down.")
        public @Setting.Constrain.Range(min=2.2250738585072014E-308) double minimumZoomDivisor = 1.0;
        @Setting(comment="The maximum value that you can scroll up.")
        public @Setting.Constrain.Range(min=2.2250738585072014E-308) double maximumZoomDivisor = 50.0;
        @Setting(comment="The number which is de/incremented by zoom scrolling. Used when the zoom divisor is above the starting point.")
        public @Setting.Constrain.Range(min=0.0) double scrollStep = 1.0;
        @Setting(comment="The number which is de/incremented by zoom scrolling. Used when the zoom divisor is below the starting point.")
        public double lesserScrollStep = 0.5;
        @Setting(comment="The multiplier used for the multiplied cinematic camera.")
        public @Setting.Constrain.Range(min=2.2250738585072014E-308) double cinematicMultiplier = 4.0;
        @Setting(comment="The multiplier used for smooth transitions.")
        public @Setting.Constrain.Range(min=2.2250738585072014E-308, max=1.0) double smoothMultiplier = 0.75;
        @Setting(comment="The minimum value which the linear transition step can reach.")
        public @Setting.Constrain.Range(min=0.0) double minimumLinearStep = 0.125;
        @Setting(comment="The maximum value which the linear transition step can reach.")
        public @Setting.Constrain.Range(min=2.2250738585072014E-308) double maximumLinearStep = 0.25;
    }

    public static class TweaksGroup {
        @Setting(comment="Allows for resetting the zoom with the middle mouse button.")
        public boolean resetZoomWithMouse = true;
        @Setting(comment="If enabled, the \"Save Toolbar Activator\" keybind will be unbound if there's a conflict with the zoom key.")
        public boolean unbindConflictingKey = true;
        @Setting(comment="Prints a random owo in the console when the game starts.")
        public boolean printOwoOnStart = false;
        @Setting(comment="Hides the zoom overlay while the HUD's hidden.")
        public boolean hideZoomOverlay = false;
    }
}

