/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.event;

import com.terraformersmc.modmenu.api.ModMenuApi;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.ModMenuButtonWidget;
import com.terraformersmc.modmenu.gui.widget.ModMenuTexturedButtonWidget;
import java.util.List;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;

public class ModMenuEventHandler {
    private static final class_2960 FABRIC_ICON_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/mods_button.png");

    public static void register() {
        ScreenEvents.AFTER_INIT.register(ModMenuEventHandler::afterScreenInit);
    }

    public static void afterScreenInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (screen instanceof class_442) {
            ModMenuEventHandler.afterTitleScreenInit(screen);
        } else if (screen instanceof class_433) {
            ModMenuEventHandler.afterGameMenuScreenInit(screen);
        }
    }

    private static void afterTitleScreenInit(class_437 screen) {
        if (ModMenuConfig.MODIFY_TITLE_SCREEN.getValue()) {
            List buttons = Screens.getButtons((class_437)screen);
            int modsButtonIndex = -1;
            int spacing = 24;
            int buttonsY = screen.field_22790 / 4 + 48;
            for (int i = 0; i < buttons.size(); ++i) {
                class_339 button2 = (class_339)buttons.get(i);
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.ModsButtonStyle.CLASSIC && button2.field_22764) {
                    ModMenuEventHandler.shiftButtons(button2, modsButtonIndex == -1, 24);
                    if (modsButtonIndex == -1) {
                        buttonsY = button2.field_22761;
                    }
                }
                if (!ModMenuEventHandler.buttonHasText(button2, "menu.online")) continue;
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.ModsButtonStyle.REPLACE_REALMS) {
                    buttons.set(i, new ModMenuButtonWidget(button2.field_22760, button2.field_22761, button2.method_25368(), button2.method_25364(), ModMenuApi.createModsButtonText(), screen));
                    continue;
                }
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.ModsButtonStyle.SHRINK) {
                    button2.method_25358(98);
                }
                modsButtonIndex = i + 1;
                if (!button2.field_22764) continue;
                buttonsY = button2.field_22761;
            }
            if (modsButtonIndex != -1) {
                if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.ModsButtonStyle.CLASSIC) {
                    buttons.add(modsButtonIndex, new ModMenuButtonWidget(screen.field_22789 / 2 - 100, buttonsY + 24, 200, 20, ModMenuApi.createModsButtonText(), screen));
                } else if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.ModsButtonStyle.SHRINK) {
                    buttons.add(modsButtonIndex, new ModMenuButtonWidget(screen.field_22789 / 2 + 2, buttonsY, 98, 20, ModMenuApi.createModsButtonText(), screen));
                } else if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.ModsButtonStyle.ICON) {
                    buttons.add(modsButtonIndex, new ModMenuTexturedButtonWidget(screen.field_22789 / 2 + 104, buttonsY, 20, 20, 0, 0, FABRIC_ICON_BUTTON_LOCATION, 32, 64, button -> class_310.method_1551().method_1507((class_437)new ModsScreen(screen)), ModMenuApi.createModsButtonText()));
                }
            }
        }
    }

    private static void afterGameMenuScreenInit(class_437 screen) {
        if (ModMenuConfig.MODIFY_GAME_MENU.getValue()) {
            List buttons = Screens.getButtons((class_437)screen);
            int modsButtonIndex = -1;
            int spacing = 24;
            int buttonsY = screen.field_22790 / 4 + 8;
            ModMenuConfig.ModsButtonStyle style = ModMenuConfig.MODS_BUTTON_STYLE.getValue().forGameMenu();
            for (int i = 0; i < buttons.size(); ++i) {
                class_339 button2 = (class_339)buttons.get(i);
                if (style == ModMenuConfig.ModsButtonStyle.CLASSIC && button2.field_22764) {
                    ModMenuEventHandler.shiftButtons(button2, modsButtonIndex == -1, 24);
                    if (modsButtonIndex == -1) {
                        buttonsY = button2.field_22761;
                    }
                }
                if (!ModMenuEventHandler.buttonHasText(button2, "menu.reportBugs")) continue;
                modsButtonIndex = i + 1;
                if (style == ModMenuConfig.ModsButtonStyle.SHRINK) {
                    buttons.set(i, new ModMenuButtonWidget(button2.field_22760, button2.field_22761, button2.method_25368(), button2.method_25364(), ModMenuApi.createModsButtonText(), screen));
                    continue;
                }
                modsButtonIndex = i + 1;
                if (!button2.field_22764) continue;
                buttonsY = button2.field_22761;
            }
            if (modsButtonIndex != -1) {
                if (style == ModMenuConfig.ModsButtonStyle.CLASSIC) {
                    buttons.add(modsButtonIndex, new ModMenuButtonWidget(screen.field_22789 / 2 - 102, buttonsY + 24, 204, 20, ModMenuApi.createModsButtonText(), screen));
                } else if (style == ModMenuConfig.ModsButtonStyle.ICON) {
                    buttons.add(modsButtonIndex, new ModMenuTexturedButtonWidget(screen.field_22789 / 2 + 4 + 100 + 2, screen.field_22790 / 4 + 72 + -16, 20, 20, 0, 0, FABRIC_ICON_BUTTON_LOCATION, 32, 64, button -> class_310.method_1551().method_1507((class_437)new ModsScreen(screen)), ModMenuApi.createModsButtonText()));
                }
            }
        }
    }

    private static boolean buttonHasText(class_339 button, String translationKey) {
        class_2561 text = button.method_25369();
        return text instanceof class_2588 && ((class_2588)text).method_11022().equals(translationKey);
    }

    private static void shiftButtons(class_339 button, boolean shiftUp, int spacing) {
        button.field_22761 = shiftUp ? (button.field_22761 -= spacing / 2) : (button.field_22761 += spacing - spacing / 2);
    }
}

