/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget.entries;

import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.widget.ModListWidget;
import com.terraformersmc.modmenu.util.DrawingUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModBadgeRenderer;
import java.util.Objects;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1074;
import net.minecraft.class_2477;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModListEntry
extends class_4280.class_4281<ModListEntry> {
    public static final class_2960 UNKNOWN_ICON = new class_2960("textures/misc/unknown_pack.png");
    private static final Logger LOGGER = LogManager.getLogger();
    protected final class_310 client;
    public final Mod mod;
    protected final ModListWidget list;
    protected class_2960 iconLocation;
    protected static final int FULL_ICON_SIZE = 32;
    protected static final int COMPACT_ICON_SIZE = 19;

    public ModListEntry(Mod mod, ModListWidget list) {
        this.mod = mod;
        this.list = list;
        this.client = class_310.method_1551();
    }

    public void method_25343(class_4587 matrices, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        class_2585 name;
        int iconSize;
        x += this.getXOffset();
        rowWidth -= this.getXOffset();
        int n = iconSize = ModMenuConfig.COMPACT_LIST.getValue() ? 19 : 32;
        if ("java".equals(this.mod.getId())) {
            DrawingUtil.drawRandomVersionBackground(this.mod, matrices, x, y, iconSize, iconSize);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindIconTexture();
        RenderSystem.enableBlend();
        class_332.method_25290((class_4587)matrices, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)iconSize, (int)iconSize, (int)iconSize, (int)iconSize);
        RenderSystem.disableBlend();
        class_2585 trimmedName = name = new class_2585(this.mod.getName());
        int maxNameWidth = rowWidth - iconSize - 3;
        class_327 font = this.client.field_1772;
        if (font.method_27525((class_5348)name) > maxNameWidth) {
            class_5348 ellipsis = class_5348.method_29430((String)"...");
            trimmedName = class_5348.method_29433((class_5348[])new class_5348[]{font.method_1714((class_5348)name, maxNameWidth - font.method_27525(ellipsis)), ellipsis});
        }
        font.method_27528(matrices, class_2477.method_10517().method_30934((class_5348)trimmedName), (float)(x + iconSize + 3), (float)(y + 1), 0xFFFFFF);
        if (!ModMenuConfig.HIDE_BADGES.getValue()) {
            new ModBadgeRenderer(x + iconSize + 3 + font.method_27525((class_5348)name) + 2, y, x + rowWidth, this.mod, this.list.getParent()).draw(matrices, mouseX, mouseY);
        }
        if (!ModMenuConfig.COMPACT_LIST.getValue()) {
            String summary = this.mod.getSummary();
            String translatableSummaryKey = "modmenu.summaryTranslation." + this.mod.getId();
            String translatableDescriptionKey = "modmenu.descriptionTranslation." + this.mod.getId();
            if (class_1074.method_4663((String)translatableSummaryKey)) {
                summary = class_1074.method_4662((String)translatableSummaryKey, (Object[])new Object[0]);
            } else if (class_1074.method_4663((String)translatableDescriptionKey)) {
                summary = class_1074.method_4662((String)translatableDescriptionKey, (Object[])new Object[0]);
            }
            Objects.requireNonNull(this.client.field_1772);
            DrawingUtil.drawWrappedString(matrices, summary, x + iconSize + 3 + 4, y + 9 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        } else {
            String string = "v" + this.mod.getVersion();
            Objects.requireNonNull(this.client.field_1772);
            DrawingUtil.drawWrappedString(matrices, string, x + iconSize + 3, y + 9 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        }
    }

    public boolean method_25402(double v, double v1, int i) {
        this.list.select(this);
        return true;
    }

    public Mod getMod() {
        return this.mod;
    }

    public void bindIconTexture() {
        if (this.iconLocation == null) {
            this.iconLocation = new class_2960("modmenu", this.mod.getId() + "_icon");
            class_1043 icon = this.mod.getIcon(this.list.getIconHandler(), 64 * class_310.method_1551().field_1690.field_1868);
            if (icon != null) {
                this.client.method_1531().method_4616(this.iconLocation, (class_1044)icon);
            } else {
                this.iconLocation = UNKNOWN_ICON;
            }
        }
        this.client.method_1531().method_22813(this.iconLocation);
    }

    public int getXOffset() {
        return 0;
    }
}

