/*
 * Decompiled with CFR 0.152.
 */
package felinoid.ore_reeds.blocks;

import felinoid.ore_reeds.config.ReedConfig;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class BlockOreReed
extends Block
implements IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208171_X;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public ReedConfig stats;

    protected BlockOreReed(String name, ReedConfig config) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)MaterialColor.field_151670_w).func_200942_a().func_200944_c().func_200948_a(0.0f, 0.0f).func_200947_a(SoundType.field_185850_c));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
        this.stats = config;
        this.setRegistryName(name);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if ((worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this || this.checkForDrop((World)worldIn, pos, state)) && worldIn.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (worldIn.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)state.func_177229_b((Property)AGE);
                if (rand.nextInt() % this.stats.slowdown == 0 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                    if (j == 15) {
                        worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
                    } else {
                        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
                }
            }
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState stateIn, IWorldReader worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (block == this) {
            return true;
        }
        if (!this.canGrowOn(block)) {
            return false;
        }
        BlockPos blockpos = pos.func_177977_b();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockstate = worldIn.func_180495_p(blockpos.func_177972_a(direction));
            if (blockstate.func_185904_a() != Material.field_151587_i) continue;
            return true;
        }
        return false;
    }

    protected final boolean checkForDrop(World worldIn, BlockPos pos, BlockState state) {
        if (this.canBlockStay(worldIn, pos)) {
            return true;
        }
        worldIn.func_175655_b(pos, true);
        return false;
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        return this.func_196260_a(null, (IWorldReader)worldIn, pos);
    }

    protected boolean canGrowOn(Block blockIn) {
        String name = blockIn.getRegistryName().toString();
        return Arrays.asList(this.stats.growBlocks).contains(name);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.BEACH;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.func_176223_P();
    }
}

