/*
 * Decompiled with CFR 0.152.
 */
package io.github.darealturtywurty.peasmod.common.blocks;

import io.github.darealturtywurty.peasmod.common.blocks.PeaGrowthStage;
import io.github.darealturtywurty.peasmod.core.init.ItemInit;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.PlantType;

public class PeaPlantBlock
extends BushBlock
implements IGrowable {
    public static final EnumProperty<PeaGrowthStage> STAGE = EnumProperty.func_177709_a((String)"stage", PeaGrowthStage.class);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), VoxelShapes.func_197868_b(), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0)};

    public PeaPlantBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        boolean b = super.func_196260_a(state, world, pos);
        if (state.func_177229_b(STAGE) == PeaGrowthStage.TOP0) {
            BlockState stateBelow = world.func_180495_p(pos.func_177977_b());
            b = stateBelow.func_177230_c() instanceof PeaPlantBlock && ((PeaGrowthStage)((Object)stateBelow.func_177229_b(STAGE))).ordinal() >= PeaGrowthStage.BOTTOM3.ordinal();
        }
        return b;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{STAGE});
    }

    public float getGrowthSpeed(World world, BlockPos pos, float light) {
        BlockState soil;
        float growth = 0.125f * (light - 11.0f);
        if (world.func_226660_f_(pos)) {
            growth += 2.0f;
        }
        if ((soil = world.func_180495_p(pos.func_177977_b())).func_177230_c().isFertile(soil, (IBlockReader)world, pos.func_177977_b())) {
            growth *= 1.5f;
        }
        return 1.0f + growth;
    }

    public PeaGrowthStage getMaxStage() {
        return PeaGrowthStage.BOTTOM6;
    }

    public PeaGrowthStage getMinStage() {
        return PeaGrowthStage.BOTTOM0;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ((Item)ItemInit.PEA.get()).func_190903_i();
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.CROP;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_AGE[((PeaGrowthStage)((Object)state.func_177229_b(STAGE))).ordinal()];
    }

    public float func_226891_m_() {
        return 0.75f;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return this.func_176473_a((IBlockReader)world, pos, state, world.field_72995_K);
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        PeaGrowthStage stage = (PeaGrowthStage)((Object)state.func_177229_b(STAGE));
        if (stage != this.getMaxStage() && stage != PeaGrowthStage.TOP0) {
            return true;
        }
        return stage == PeaGrowthStage.BOTTOM6 && world.func_180495_p(pos.func_177984_a()).func_177230_c() != this;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_177230_c() == Blocks.field_150458_ak;
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        if (world instanceof World) {
            World realWorld = (World)world;
            if (pos.func_177958_n() == neighbor.func_177958_n() && pos.func_177952_p() == neighbor.func_177952_p() && pos.func_177956_o() == neighbor.func_177956_o() + 1 && realWorld.func_180495_p(neighbor).func_177229_b(STAGE) == PeaGrowthStage.TOP0) {
                realWorld.func_175655_b(pos, true);
                realWorld.func_175655_b(pos.func_177984_a(), true);
            }
            if (realWorld.func_180495_p(pos).func_177229_b(STAGE) != PeaGrowthStage.TOP0) {
                realWorld.func_195593_d(pos.func_177984_a(), (Block)this);
            }
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        if (state.func_177229_b(STAGE) == PeaGrowthStage.TOP0) {
            world.func_175655_b(pos.func_177977_b(), true);
        }
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        PeaGrowthStage stage = (PeaGrowthStage)((Object)state.func_177229_b(STAGE));
        if (stage != PeaGrowthStage.TOP0 && stage != PeaGrowthStage.BOTTOM6) {
            int span = this.getMaxStage().ordinal() - stage.ordinal();
            int growBy = this.RANDOM.nextInt(span) + 1;
            PeaGrowthStage newStage = stage;
            for (int stageAdd = 0; stageAdd < growBy; ++stageAdd) {
                newStage = newStage.next();
            }
            world.func_175656_a(pos, (BlockState)state.func_206870_a(STAGE, (Comparable)((Object)newStage)));
            stage = newStage;
        }
        if (world.func_175623_d(pos.func_177984_a()) && stage.ordinal() >= PeaGrowthStage.BOTTOM3.ordinal() && stage != PeaGrowthStage.TOP0) {
            world.func_175656_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(STAGE, (Comparable)((Object)PeaGrowthStage.TOP0)));
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        int light = world.func_201696_r(pos);
        if (light >= 12) {
            PeaGrowthStage stage = (PeaGrowthStage)((Object)state.func_177229_b(STAGE));
            float speed = this.getGrowthSpeed((World)world, pos, light);
            if (random.nextInt((int)(50.0f / speed) + 1) == 0) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a(STAGE, (Comparable)((Object)stage.next())));
                if (stage.ordinal() >= PeaGrowthStage.BOTTOM3.ordinal() && world.func_175623_d(pos.func_177984_a()) && stage != PeaGrowthStage.TOP0) {
                    world.func_175656_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(STAGE, (Comparable)((Object)PeaGrowthStage.TOP0)));
                }
            }
        }
    }
}

