/*
 * Decompiled with CFR 0.152.
 */
package io.github.darealturtywurty.peasmod.core.world;

import com.mojang.serialization.Codec;
import io.github.darealturtywurty.peasmod.common.blocks.PeaPlantBlock;
import io.github.darealturtywurty.peasmod.core.init.BlockInit;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.Tags;

public class PeaPlantFeature
extends Feature<BlockClusterFeatureConfig> {
    private static boolean isNearWater(IWorldReader world, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (!world.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((IWorldReader)world, (BlockPos)pos);
    }

    public PeaPlantFeature(Codec<BlockClusterFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos pos, BlockClusterFeatureConfig config) {
        if (rand.nextInt(5) == 0) {
            BlockPos blockpos = null;
            blockpos = config.field_227298_k_ ? world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, pos) : pos;
            int quantity = 0;
            BlockPos.Mutable mutablePos = new BlockPos.Mutable();
            for (int j = 0; j < config.field_227293_f_; ++j) {
                mutablePos.func_239621_a_((Vector3i)blockpos, rand.nextInt(config.field_227294_g_ + 1) - rand.nextInt(config.field_227294_g_ + 1), rand.nextInt(config.field_227295_h_ + 1) - rand.nextInt(config.field_227295_h_ + 1), rand.nextInt(config.field_227296_i_ + 1) - rand.nextInt(config.field_227296_i_ + 1));
                BlockPos.Mutable cropPos = mutablePos;
                BlockPos belowPos = mutablePos.func_177977_b();
                BlockState crop = world.func_180495_p((BlockPos)cropPos);
                BlockState below = world.func_180495_p(belowPos);
                if (crop.func_185904_a().func_76220_a() || !crop.func_204520_s().func_206888_e() || !below.func_235714_a_((ITag)Tags.Blocks.DIRT) || !PeaPlantFeature.isNearWater((IWorldReader)world, belowPos)) continue;
                world.func_180501_a(belowPos, Blocks.field_150458_ak.func_176223_P(), 2);
                world.func_180501_a((BlockPos)cropPos, ((PeaPlantBlock)BlockInit.PEA_PLANT.get()).func_176223_P(), 2);
                ++quantity;
            }
            return quantity > 0;
        }
        return false;
    }
}

