/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui;

import com.minelittlepony.common.client.gui.ITextContext;
import com.minelittlepony.common.client.gui.ITooltipped;
import com.minelittlepony.common.client.gui.IViewRoot;
import com.minelittlepony.common.client.gui.ToolTipRenderer;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.dimension.Padding;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;

public abstract class GameGui
extends Screen
implements IViewRoot,
ITextContext {
    private final Bounds bounds = new Bounds(0, 0, 0, 0);
    private final Padding padding = new Padding(0, 0, 0, 0);
    private final ToolTipRenderer tooltip = new ToolTipRenderer(this);
    @Nullable
    protected final Screen parent;

    protected GameGui(ITextComponent title) {
        this(title, Minecraft.func_71410_x().field_71462_r);
    }

    protected GameGui(ITextComponent title, @Nullable Screen parent) {
        super(title);
        this.parent = parent;
    }

    public static void playSound(SoundEvent event) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)event, (float)1.0f));
    }

    public static boolean isKeyDown(int key) {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)key);
    }

    public static Supplier<Boolean> keyCheck(int key) {
        return () -> GameGui.isKeyDown(key);
    }

    public List<Widget> buttons() {
        return this.field_230710_m_;
    }

    public List<IGuiEventListener> func_231039_at__() {
        return this.field_230705_e_;
    }

    public <T extends Widget> T func_230480_a_(T button) {
        return (T)super.func_230480_a_(button);
    }

    public void func_231158_b_(Minecraft mc, int width, int height) {
        this.bounds.width = width;
        this.bounds.height = height;
        super.func_231158_b_(mc, width, height);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.field_230710_m_.forEach(button -> {
            if (button instanceof ITooltipped && button.func_231047_b_((double)mouseX, (double)mouseY)) {
                ((ITooltipped)button).renderToolTip(matrices, this, mouseX, mouseY);
            }
        });
    }

    public void finish() {
        this.func_231164_f_();
        this.field_230706_i_.func_147108_a(this.parent);
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Bounds bounds) {
    }

    @Override
    public Padding getContentPadding() {
        return this.padding;
    }

    @Override
    public List<IGuiEventListener> getChildElements() {
        return this.func_231039_at__();
    }

    public void func_238654_b_(MatrixStack matrices, List<? extends IReorderingProcessor> text, int x, int y) {
        this.tooltip.render(matrices, text, x, y);
    }
}

