/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public interface Tooltip {
    public static final Splitter LINE_SPLITTER = Splitter.onPattern((String)"\r?\n|\\\\n");

    public List<ITextComponent> getLines();

    default public CharSequence getString() {
        StringBuilder builder = new StringBuilder();
        this.getLines().forEach(line -> {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(line.func_150261_e());
        });
        return builder;
    }

    default public Stream<ITextComponent> stream() {
        return this.getLines().stream();
    }

    public static Tooltip of(String text) {
        return Tooltip.of((ITextComponent)new TranslationTextComponent(text));
    }

    public static Tooltip of(List<ITextComponent> lines) {
        List flines = lines.stream().map(Tooltip::of).flatMap(Tooltip::stream).collect(Collectors.toList());
        return () -> flines;
    }

    public static Tooltip of(ITextComponent text) {
        ArrayList<StringTextComponent> lines = new ArrayList<StringTextComponent>();
        lines.add(new StringTextComponent(""));
        text.func_230439_a_((style, part) -> {
            List parts = LINE_SPLITTER.splitToList((CharSequence)part).stream().map(i -> new StringTextComponent(i).func_240703_c_(style)).collect(Collectors.toList());
            lines.add((StringTextComponent)((IFormattableTextComponent)lines.remove(lines.size() - 1)).func_230529_a_((ITextComponent)parts.remove(0)));
            lines.addAll(parts);
            return Optional.empty();
        }, text.func_150256_b());
        return () -> lines;
    }
}

