/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.IField;
import com.minelittlepony.common.client.gui.element.Button;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;

public abstract class AbstractSlider<T>
extends Button
implements IField<T, AbstractSlider<T>> {
    private float min;
    private float max;
    private float value;
    @Nonnull
    private IField.IChangeCallback<T> action = IField.IChangeCallback::none;
    @Nullable
    private Function<T, String> formatter;

    public AbstractSlider(int x, int y, float min, float max, T value) {
        super(x, y);
        this.min = min;
        this.max = max;
        this.value = AbstractSlider.convertFromRange(this.valueToFloat(value), min, max);
    }

    protected abstract float valueToFloat(T var1);

    protected abstract T floatToValue(float var1);

    @Override
    public AbstractSlider<T> onChange(@Nonnull IField.IChangeCallback<T> action) {
        this.action = action;
        return this;
    }

    public AbstractSlider<T> setFormatter(@Nonnull Function<T, String> formatter) {
        this.formatter = formatter;
        this.getStyle().setText(formatter.apply(this.getValue()));
        return this;
    }

    @Override
    public AbstractSlider<T> setValue(T value) {
        this.setClampedValue(AbstractSlider.convertFromRange(this.valueToFloat(value), this.min, this.max));
        return this;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.field_230693_o_ && this.field_230694_p_ && (keyCode == 263 || keyCode == 262)) {
            this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            float step = (this.max - this.min) / 4.0f;
            if (keyCode == 263) {
                step *= -1.0f;
            }
            this.setClampedValue(this.value + step);
            this.func_230930_b_();
            return true;
        }
        return false;
    }

    protected void setClampedValue(float value) {
        if ((value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f)) != this.value) {
            float initial = this.value;
            this.value = value;
            this.value = AbstractSlider.convertFromRange(this.valueToFloat(this.action.perform(this.getValue())), this.min, this.max);
            if (this.value != initial && this.formatter != null) {
                this.getStyle().setText(this.formatter.apply(this.getValue()));
            }
        }
    }

    private void onChange(double mouseX) {
        this.setClampedValue((float)(mouseX - (double)(this.field_230690_l_ + 4)) / (float)(this.field_230688_j_ - 8));
    }

    @Override
    public T getValue() {
        return this.floatToValue(AbstractSlider.convertToRange(this.value, this.min, this.max));
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        super.func_230982_a_(mouseX, mouseY);
        this.onChange(mouseX);
    }

    protected void func_230983_a_(double mouseX, double mouseY, double mouseDX, double mouseDY) {
        this.onChange(mouseX);
    }

    protected void func_230441_a_(MatrixStack matrices, Minecraft mc, int mouseX, int mouseY) {
        mc.func_110434_K().func_110577_a(field_230687_i_);
        int i = 46 + (this.func_230449_g_() ? 2 : 1) * 20;
        int sliderX = this.field_230690_l_ + (int)(this.value * (float)(this.field_230688_j_ - 8));
        this.func_238474_b_(matrices, sliderX, this.field_230691_m_, 0, i, 4, 20);
        this.func_238474_b_(matrices, sliderX + 4, this.field_230691_m_, 196, i, 4, 20);
    }

    protected int func_230989_a_(boolean mouseOver) {
        return 0;
    }

    static float convertFromRange(float value, float min, float max) {
        return (MathHelper.func_76131_a((float)value, (float)min, (float)max) - min) / (max - min);
    }

    static float convertToRange(float value, float min, float max) {
        return MathHelper.func_76131_a((float)(min + value * (max - min)), (float)min, (float)max);
    }
}

