/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.ITextContext;
import com.minelittlepony.common.client.gui.ITooltipped;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.dimension.IBounded;
import com.minelittlepony.common.client.gui.style.IStyled;
import com.minelittlepony.common.client.gui.style.Style;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.StringTextComponent;

public class Button
extends AbstractButton
implements ITooltipped<Button>,
IBounded,
ITextContext,
IStyled<Button> {
    private Style style = new Style();
    private final Bounds bounds;
    private static final Consumer<Button> NONE = v -> {};
    @Nonnull
    private Consumer<Button> action = NONE;

    public Button(int x, int y) {
        this(x, y, 200, 20);
    }

    public Button(int x, int y, int width, int height) {
        super(x, y, width, height, StringTextComponent.field_240750_d_);
        this.bounds = new Bounds(y, x, width, height);
    }

    public Button onClick(@Nonnull Consumer<? extends Button> callback) {
        this.action = callback;
        return this;
    }

    public Button setEnabled(boolean enable) {
        this.field_230693_o_ = enable;
        return this;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public Button setStyle(Style style) {
        this.style = style;
        return this;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Bounds bounds) {
        this.bounds.copy(bounds);
        this.field_230690_l_ = bounds.left;
        this.field_230691_m_ = bounds.top;
        this.field_230688_j_ = bounds.width;
        this.field_230689_k_ = bounds.height;
    }

    @Override
    public void renderToolTip(MatrixStack matrices, Screen parent, int mouseX, int mouseY) {
        if (this.field_230694_p_) {
            this.getStyle().getTooltip().ifPresent(tooltip -> {});
        }
    }

    public void func_230431_b_(MatrixStack matrices, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(field_230687_i_);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int state = 46 + this.func_230989_a_(this.func_230449_g_()) * 20;
        this.renderButtonBlit(matrices, this.field_230690_l_, this.field_230691_m_, state, this.field_230688_j_, this.field_230689_k_);
        this.func_230441_a_(matrices, mc, mouseX, mouseY);
        int foreColor = this.getStyle().getColor();
        if (!this.field_230693_o_) {
            foreColor = 0xA0A0A0;
        } else if (this.func_230449_g_()) {
            foreColor = 0xFFFFA0;
        }
        if (this.getStyle().hasIcon()) {
            this.getStyle().getIcon().render(matrices, this.field_230690_l_, this.field_230691_m_, mouseX, mouseY, partialTicks);
        }
        this.func_238482_a_(this.getStyle().getText());
        this.renderForground(matrices, mc, mouseX, mouseY, foreColor | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24);
    }

    protected void renderForground(MatrixStack matrices, Minecraft mc, int mouseX, int mouseY, int foreColor) {
        this.drawCenteredLabel(matrices, this.func_230458_i_(), this.field_230690_l_ + this.field_230688_j_ / 2, this.field_230691_m_ + (this.field_230689_k_ - 8) / 2, foreColor, 0.0);
    }

    public void func_230930_b_() {
        this.action.accept(this);
    }

    protected final void renderButtonBlit(MatrixStack matrices, int x, int y, int state, int blockWidth, int blockHeight) {
        int endV = 200 - blockWidth / 2;
        int endU = state + 20 - blockHeight / 2;
        this.func_238474_b_(matrices, x, y, 0, state, blockWidth / 2, blockHeight / 2);
        this.func_238474_b_(matrices, x + blockWidth / 2, y, endV, state, blockWidth / 2, blockHeight / 2);
        this.func_238474_b_(matrices, x, y + blockHeight / 2, 0, endU, blockWidth / 2, blockHeight / 2);
        this.func_238474_b_(matrices, x + blockWidth / 2, y + blockHeight / 2, endV, endU, blockWidth / 2, blockHeight / 2);
    }
}

